<?php

namespace App\Http\Middleware;

use App\Jobs\LicenseCheckJob;
use Closure;
use Illuminate\Http\Request;
use App\Models\LicenseCheckModel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Artisan;

class CheckBanned
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        if (auth()->check() && (auth()->user()->isActive == 'no')) {
            Auth::logout();

            $request->session()->invalidate();
            $request->session()->regenerateToken();
            return redirect()->route('login')->with('error', 'Your Account is suspended, please contact Admin.');
        }



        // if (config('app.license_check') == true && request()->getRequestUri() != '/license-reset') {
        if ((siteLicenseInfo() == "true" || config('app.license_check') == true) && request()->getRequestUri() != '/license-reset') {

            $last_license_check = license();

            if (!$last_license_check || $last_license_check->created_at->diffInDays(now()) > 1) {
                LicenseCheckJob::dispatch();
                cache()->forget('last_license_check');

                // abort(403, 'License is missing. Please reload the site or contact the software vendor (Yetfix Limited).');
            }


        }





        return $next($request);
    }
}
