<?php

namespace App\Http\Controllers;

use App\Models\Pop;
use App\Models\SubPackage;
use Illuminate\Http\Request;
use App\Models\NewLineRequest;
use App\Models\NewLineRequestRemarks;
use Illuminate\Support\Facades\DB;
use Brian2694\Toastr\Facades\Toastr;

class NewLineRequestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pops = Pop::all();

        $newLineRequests = NewLineRequest::with('pop', 'package', 'user', 'subPackage', 'remarksList')->orderBy('updated_at', 'asc')->get();

        if(request('status') == null && request('pop_id') == null){
            $newLineRequests = $newLineRequests->where('status', 'pending');
        }

        if (request('pop_id')) {
            $newLineRequests = $newLineRequests->where('pop_id', request('pop_id'));
        }

        if (request('status')) {
            $newLineRequests = $newLineRequests->where('status', request('status'));
        }


        return view('clients.newclient.index', [
            'page_title' => 'New Line Request',
            'lists' => $newLineRequests,
            'pops' => $pops,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $confday = config('app.billing_cycle');
        $pops = Pop::all();
        return view('clients.newclient.create', [
            'page_title' => 'Create New Line Request',
            'pops' => $pops,
            'confday' => $confday,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'address' => 'required',
            'pop_id' => 'required',
            'package_id' => 'required',
            'otc' => 'required|numeric',
            'phone' => 'required',
            'fiber_meter' => 'required|numeric',
            'notes' => 'nullable',
            'billing_date' => 'required',
            'nid' => 'nullable',
            'alt_phone' => 'nullable',
        ]);
        // dd($request->all());

        $pop = Pop::find($request->pop_id);
        if ($pop->subreseller == 'yes') {
            $subPackageId = SubPackage::where('id', $request->package_id)->first();
            $packageId = $subPackageId->package_id ?? null;
        }
        else {
            $packageId = $request->package_id;
        }

        try{
            DB::beginTransaction();

            $newLineRequest = new NewLineRequest();
            $newLineRequest->name = $request->name;
            $newLineRequest->father_name = $request->father_name;
            $newLineRequest->mother_name = $request->mother_name;
            $newLineRequest->phone = $request->phone;
            $newLineRequest->alt_phone = $request->alt_phone;
            $newLineRequest->nid = $request->nid;
            $newLineRequest->billing_date = $request->billing_date;
            $newLineRequest->address = $request->address;
            $newLineRequest->pop_id = $request->pop_id;
            $newLineRequest->package_id = $packageId;
            if ($pop->subreseller == 'yes') {
                $newLineRequest->sub_package_id = $request->package_id;
            } else {
                $newLineRequest->sub_package_id = null;
            }
            $newLineRequest->otc = $request->otc;
            $newLineRequest->fiver_miter = $request->fiber_meter;
            $newLineRequest->lat = $request->latitude;
            $newLineRequest->long = $request->longitude;
            $newLineRequest->created_by = auth()->user()->id;
            $newLineRequest->status = 'pending';
            $newLineRequest->save();

            $newLineRequestRemark = new NewLineRequestRemarks();
            $newLineRequestRemark->new_line_request_id = $newLineRequest->id;
            $newLineRequestRemark->remarks = $request->notes;
            $newLineRequestRemark->created_by = auth()->user()->id;
            $newLineRequestRemark->save();

            DB::commit();

        }catch(\Exception $e){
            DB::rollBack();
            Toastr::error('Something went wrong');
            return redirect()->back()->withInput();
        }

        Toastr::success('New Line Request created successfully');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function show(NewLineRequest $newLineRequest)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function edit(NewLineRequest $newLineRequest)
    {
        $confday = config('app.billing_cycle');
        $pops = Pop::all();
        $newLineRequest->load('pop', 'package');
        return view('clients.newclient.edit', [
            'page_title' => 'Edit New Line Request',
            'newLineRequest' => $newLineRequest,
            'pops' => $pops,
            'confday' => $confday,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NewLineRequest $newLineRequest)
    {
        $request->validate([
            'name' => 'required',
            'address' => 'required',
            'pop_id' => 'required',
            'package_id' => 'required',
            'otc' => 'required|numeric',
            'phone' => 'required',
            'fiber_meter' => 'required|numeric',
            'notes' => 'nullable',
            'billing_date' => 'required',
            'nid' => 'nullable',
            'alt_phone' => 'nullable',
        ]);

        $pop = Pop::find($request->pop_id);
        if ($pop->subreseller == 'yes') {
            $subPackageId = SubPackage::where('id', $request->package_id)->first();
            $packageId = $subPackageId->package_id ?? null;
        } else {
            $packageId = $request->package_id;
        }

        $newLineRequest->name = $request->name;
        $newLineRequest->father_name = $request->father_name;
        $newLineRequest->mother_name = $request->mother_name;
        $newLineRequest->phone = $request->phone;
        $newLineRequest->alt_phone = $request->alt_phone;
        $newLineRequest->nid = $request->nid;
        $newLineRequest->billing_date = $request->billing_date;
        $newLineRequest->address = $request->address;
        $newLineRequest->pop_id = $request->pop_id;
        $newLineRequest->package_id = $packageId;
        if ($pop->subreseller == 'yes') {
            $newLineRequest->sub_package_id = $request->package_id;
        } else {
            $newLineRequest->sub_package_id = null;
        }
        $newLineRequest->otc = $request->otc;
        $newLineRequest->fiver_miter = $request->fiber_meter;
        $newLineRequest->lat = $request->latitude;
        $newLineRequest->long = $request->longitude;
        $newLineRequest->save();


        Toastr::success('New Line Request updated successfully');
        return redirect()->route('new-line-request.index');

    }

    /**
     * Update only status of the specified resource.
     */
    public function updateStatus(Request $request, NewLineRequest $new_line_request)
    {
        $request->validate([
            'status' => 'required',
        ]);

        $new_line_request->status = $request->status;
        $new_line_request->save();

        Toastr::success('Status updated');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Update only remarks of the specified resource.
     */
    public function updateRemark(Request $request, NewLineRequest $new_line_request)
    {
        // dd($request->all(), $new_line_request);
        $request->validate([
            'remarks' => 'nullable|string',
        ]);

        $newLineRequestRemark = new NewLineRequestRemarks();
        $newLineRequestRemark->new_line_request_id = $new_line_request->id;
        $newLineRequestRemark->remarks = $request->remarks;
        $newLineRequestRemark->created_by = auth()->user()->id;
        $newLineRequestRemark->save();

        Toastr::success('Remarks updated');
        return redirect()->route('new-line-request.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\NewLineRequest  $newLineRequest
     * @return \Illuminate\Http\Response
     */
    public function destroy(NewLineRequest $newLineRequest)
    {
        //
    }

    public function newLineRequestRemarks($new_line_request)
    {
        // dd($new_line_request);
        $remarks = NewLineRequestRemarks::where('new_line_request_id', $new_line_request)
                    ->orderBy('created_at', 'asc')
                    ->get();

        return view('clients.newclient.remarks', [
            'page_title' => 'Remarks List For New Line Request',
            'new_line_request' => $new_line_request,
            'remarks' => $remarks,
        ]);
    }
}
