<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientSummary;
use Illuminate\Http\Request;

class ClientSummaryController extends Controller
{
   public function storeClientSummary()
   {
        $monthYear = now()->format('M-Y');


        $clientCounts = [
            'total_clients' => Client::count(),
            'total_active_clients' => Client::where('clients_status', 'active')->count(),
            'total_expire_clients' => Client::where('clients_status', 'expired')->count(),
            'total_disable_clients' => Client::where('clients_status', 'disable')->count(),
            'total_de_active_clients' => Client::where('clients_status', 'deactive')->count(),
            'total_close_clients' => Client::onlyTrashed()->count(),
            'active_ides' => Client::where('clients_status', 'active')->pluck('id')->toJson(),
            'expire_ides' => Client::where('clients_status', 'expired')->pluck('id')->toJson(),
            'disable_ides' => Client::where('clients_status', 'disable')->pluck('id')->toJson(),
            'de_active_ides' => Client::where('clients_status', 'deactive')->pluck('id')->toJson(),
            'close_ides' => Client::onlyTrashed()->pluck('id')->toJson(),
        ];





       $e= ClientSummary::updateOrCreate(
            ['month_year' => $monthYear],
            $clientCounts,

        );


   }
}
