<h2 class="header text-center">Payment History</h2>
<div class="table-responsive">
    <table class="table table-bordered">
        <tr>
            <th>Action</th>
            <th>Description</th>
            <th>Received/Collected By</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Discount</th>
        </tr>
        @php($total = 0)
        @php($index = 0)


        @foreach ($paymenthistory->get() as $p)
            @php($total += $p->paid_amount)

            <tr>
                <td class="text-center">

                    @can('money-receipt-destroy')
                        @if ($index == 0)
                            <form action="{{ route('paymentDelete', $p->id) }}" method="post">
                                @csrf
                                <input name="payment_id" type="hidden" value="{{ $p->id }}">
                                <button onclick="return confirm('Are you sure you want to Delete?');" type="submit"
                                    class="btn btn-danger btn-sm processConfirm">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                        @elseif(auth()->user()->id == 1)
                            <form action="{{ route('paymentDelete', $p->id) }}" method="post">
                                @csrf
                                <input name="payment_id" type="hidden" value="{{ $p->id }}">
                                <button onclick="return confirm('Are you sure you want to Delete?');" type="submit"
                                    class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                        @endif
                    @endcan
                    @if (checkSettings('print-invoice') == 'enable')
                        @if (checkSettings('only-last-invoice-print') == 'enable')
                            @if (auth()->user()->hasRole('Admin'))
                                <a href="{{ route('invoice-print', $p->id) }}" target="_blank"
                                    class="mt-1 btn btn-primary btn-sm">
                                    <i class="fa fa-print"></i>
                                </a>
                            @elseif (auth()->user()->hasPermissionTo('print-invoice'))
                                @if ($index == 0)
                                    <a href="{{ route('invoice-print', $p->id) }}" target="_blank"
                                        class="mt-1 btn btn-primary btn-sm">
                                        <i class="fa fa-print"></i>
                                    </a>
                                @endif
                            @endif
                        @else
                            <a href="{{ route('invoice-print', $p->id) }}" target="_blank"
                                class="mt-1 btn btn-primary btn-sm">
                                <i class="fa fa-print"></i>
                            </a>
                        @endif
                    @endif
                    <p>Id: {{ $p->id }}</p>

                </td>


                <td> <span class="badge badge-primary">Date: </span> {{ $p->created_at }} <br>
                    <span class="badge badge-primary">MR ID: </span> {{ $p->money_receipt_number }} <br>
                    <span class="badge badge-primary">DS: </span> {{ $p->description }}
                    @if(isset($p->user))
                        @if ($p->user->name == "Bkash-Webhook")
                            <br><span class="badge badge-primary">Payment No: </span> {{ $p->customerMsisdn ?? '' }}
                        @endif
                    @endif
                </td>

                <td class="text-left"><span class="badge badge-success">R.By: </span>
                    {{ $p->user->name ?? 'Online Payment' }} <br> <span class="badge badge-success">C.By: </span>
                    {{ $p->employee->name ?? '' }}</td>

                <td>{{ $p->income->name ?? '' }}</td>
                <td class="text-right">{{ $p->paid_amount }}</td>
                <td class="text-right">{{ $p->discount_amount }}</td>

            </tr>
            @php($index++)
        @endforeach

        <tr>
            <th colspan="4" class="text-right">Total Amount: </th>
            <th class="text-right">{{ $total }} TK</th>
            <th class="text-right">{{ $paymenthistory->sum('discount_amount') }}</th>
        </tr>
    </table>
</div>
