<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SearchTokenExport implements FromCollection, WithHeadings, ShouldAutoSize
{

    public function headings(): array
    {
        $dataArray = [
            'Client ID',
            'POP',
            'Call Receive Time',
            'Complain Details',
            'Complain Code',
            'Ping (Packet Loss)',
            'Package',
            'Optical Power',
            'Mobile Number',
            'Creator Name',
            '1st Response',
            'Noc Comments',
            'Remarks (Only Type of Problem)',
            'Client Feedback',
            'Solved By',
            'Issue Type',
            'Solve Time',
            'Department Head Comments',
            'Head Of Oparetion',
            'Md Sir Comments',
            'Care Line Inchange Comments',
            'Tania',
            'Mona'
        ];

        return $dataArray;
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        // dd($this->data);
        $items = [];
        foreach ($this->data as $item) {
            // dd($item);

            $items[] = [
                $item->clientId,
                $item->popname,
                $item->created_at ? date('Y-m-d H:i:s', strtotime($item->created_at)) : '',
                $item->description ?? '',
                $item->code,
                $item->ping_loss,
                $item->package_name,
                $item->optical_power,
                $item->reporterContact,
                $item->createBy ?? $item->createByClient,
                $item->employee,
                $item->remarks,
                $item->remarks,
                // $item->code,
                $item->client_feedback,
                $item->closedBy,
                $item->issue_type,
                $item->close_time ? date('Y-m-d H:i:s', strtotime($item->close_time)) : '',
                '',
                '',
                '',
                '',
                '',
                ''
            ];

            $items = array_values($items);
        }
        return collect($items);
    }
}
