<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard-billing-info')): ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pop-wise-dashboard-report')): ?>

        <section class="card">
            <div class="card-header">
                <h1 class="card-title float-none">Report Pop/Sub Manager wise (only own) of Monthly Generated Bill Collection
                    <?php echo e(date('M')); ?>

                    <?php echo e(date('Y')); ?></h1>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover table-responsive-lg">
                        <thead>
                            <tr>
                                <th scope="col" class="h6 ">Pop/Sub Manager</th>
                                <th scope="col" class="h6">Bill Client</th>
                                <th scope="col" class="h6 text-right">Bill Amount</th>
                                <th scope="col" class="h6">Received Client</th>
                                <th scope="col" class="h6 text-right">Received Amount</th>
                                <th scope="col" class="h6 text-right">Discount Amount</th>
                                <th scope="col" class="h6">Collection(%)</th>
                                <th scope="col" class="h6">Dues Clients</th>
                                <th scope="col" class="h6 text-right">Dues Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $dueClients = 0;
                                $dueAmounts = 0;
                                $clientscount = 0;
                                $totalBill = 0;
                                $totalAdjustment = 0;
                                $totalPaid = 0;
                                $totalDiscount = 0;
                            ?>

                    <?php $__currentLoopData = $popWiseBillReport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $totalBill += $item->total_bill;
                            $clientscount += $item->total_row;
                            $dueClients += $item->not_paid;
                            $dueAmounts += $item->total_bill - $item->total_paid;
                            $totalPaid += $item->total_paid - $item->total_discount;
                            $totalDiscount += $item->total_discount;

                        ?>
                        <tr>
                            <td><?php echo e($item->popname); ?></td>
                            <td><?php echo e($item->total_row); ?></td>
                            <td class="text-right">
                                <span class="bg-danger py-1 px-3 rounded text-right">
                                    <?php echo e($item->total_bill); ?>

                                </span>
                            </td>
                            <td><?php echo e($item->total_row - $item->not_paid); ?></td>
                            <td class="text-right"><?php echo e($item->total_paid - $item->total_discount); ?></td>
                            <td class="text-right"><?php echo e($item->total_discount); ?></td>
                            <td>
                                <?php if($item->total_bill!=0 && $item->total_paid != 0): ?>
                                <?php echo e(round(($item->total_paid * 100) / $item->total_bill,2)); ?>%
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($item->not_paid ?? 0); ?></td>
                            <td class="text-right"><?php echo e($item->total_bill - $item->total_paid); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6"><?php echo e($clientscount); ?></td>
                        <td class="h6 text-right"><?php echo e($totalBill); ?></td>
                        <td class="h6"><?php echo e($clientscount - $dueClients); ?></td>
                        <td class="h6 text-right"><?php echo e(round($totalPaid)); ?></td>
                        <td class="h6 text-right"><?php echo e(round($totalDiscount)); ?></td>
                        <td class="h6">
                            <span class="text-default">
                                <?php if($totalBill != 0): ?>
                                    
                                    <?php echo e(round((($totalPaid +$totalDiscount) * 100) / $totalBill, 2)); ?> %
                                <?php else: ?>
                                    0%
                                <?php endif; ?>
                            </span>

                                </td>
                                <td class="h6 text-center">
                                    <?php echo e($dueClients); ?>

                                </td>

                                <td class="h6 text-center">

                                    <?php echo e(round($dueAmounts)); ?>


                                </td>

                    </tr>
                </tbody>
            </table>
        </section>

    <?php endif; ?>
<?php endif; ?>



<style>
    .card-title {
        font-size: 32px !important;
        text-align: center !important;
        letter-spacing: 0.10rem;
        font-weight: 500;
    }

    .manager-bg {
        background-color: rgb(221 214 254 / 0.05);
        --tw-text-opacity: 1;
        color: rgb(3 7 18 / var(--tw-text-opacity));
    }

    .table-data {
        background-color: rgb(255 241 242 / 0.5);
        --tw-text-opacity: 1;
        color: rgb(15 23 42 / var(--tw-text-opacity));
    }
</style>
<?php /**PATH /var/www/html/narayanpuronline/radius-circle/resources/views/dashboard/new/popWiseReport.blade.php ENDPATH**/ ?>