@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">

            <div class="float-right my-2">
                <a href="{{ route('voice-gateway.create') }}" class="btn btn-primary pull-right">Add Voice Gateway</a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="display table table-sm">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Name</th>
                            <th scope="col">Caller ID</th>
                            <th scope="col">Retry Count</th>
                            <th scope="col">Username</th>
                            <th scope="col">API URL</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($gateway as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->caller_id ?? 'N/A' }}</td>
                                <td>{{ $item->retry_count ?? 0 }}</td>
                                <td>{{ $item->username }}</td>
                                <td>{{ Str::limit($item->api_url, 40) }}</td>
                                <td>
                                    @if($item->status == 'enable')
                                        <span class="badge badge-success">Enable</span>
                                    @else
                                        <span class="badge badge-danger">Disable</span>
                                    @endif
                                </td>
                                <td class="text-end">
                                    <div class="btn-group" role="group" aria-label="Voice Gateway Actions">
                                        <a href="{{ route('voice-gateway.edit', $item->id) }}" class="btn btn-sm btn-primary">
                                            <i class="bi bi-pencil-square"></i> Edit
                                        </a>
                                        <a href="{{ route('editLog-history', ['id' => $item->id, 'type' => 'Voice Gateway']) }}" class="btn btn-sm btn-secondary">
                                            <i class="bi bi-clock-history"></i> History
                                        </a>
                                        <form action="{{ route('voice-gateway.destroy', $item->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">
            {{ $gateway->links() }}
        </div>
    </div>
@endsection

