@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">

                            <h3 class="card-title" style="color:#115548;">Add Income Head</h3>
                            <div class="card-tools">

                                <a href="{{ route('income.index') }}"><button class="btn btn-sm btn-info"><i
                                    class="fa fa-arrow-left" aria-hidden="true"></i> &nbsp;Income
                                List</button></a>


                                {{-- <a href="{{ route('income-head.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a> --}}
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form method="POST" action="{{ route('income-head.store') }}" enctype="multipart/form-data">
                            @csrf

                            <div class="card-body">
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Name*
                                    </label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                                </div>
                                <div class="form-group  float-right">
                                    <button type="submit" name="btn" class=" btn btn-primary">Save</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>

            <div class="card-body">
                <table id="dataTable" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Income Head</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($incomeheads as $row)
                            <tr>
                                <td>{{ $row->id }}</td>
                                {{-- <td>{{ $row->incomeHead}}</td> --}}
                                <td>{{ $row->name }}</td>
                                <td>
                                    @can('income-section')
                                    @if(!in_array($row->id,[1,2,3,4,5,6,11,12]))
                                        <div class="btn-group">
                                            <a href="{{ route('income-head.edit', $row->id) }}"
                                                class="btn btn-sm btn-primary">
                                                <i class="fa fa-pencil-square-o"></i>
                                                Edit
                                            </a>
                                        </div>

                                        {{-- <div class="btn-group">
                                            <form action="{{ route('income-head.destroy', $row) }}" method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <button id="{{ $row->id }}"
                                                    class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        </div> --}}
                                        @endif
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@push('script-bottom')


@endpush
