@extends('layout.app')


@section('content')
    <form action="{{ route('crm-item.update',$item->id) }}" method="POST">
        @method('PUT')
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="nas_id">
                            Name *
                        </label>

                        <input type="text" name="name" id="name" value="{{ $item->name}}" required
                            class="form-control" placeholder=" Name" autocomplete="off">
                        @error('name')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="nas_id">
                            Unit*
                        </label>

                        <select name="crm_item_unit_id" id="crm_item_unit_id" class="form-control" required>
                            <option value="">Select One</option>
                            @foreach ($units as $unit)
                                <option value="{{ $unit->id }}" @if ($item->crm_item_unit_id == $unit->id) selected  @endif>{{ $unit->name }}</option>
                            @endforeach
                        </select>
                        @error('item_unit')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-success float-right">
                        Save
                    </button>
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>
@endsection
