<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Cable extends Model
{
    use HasFactory;

    protected $table = "cable_map";

    protected $morphClass = 'cable';

    protected $fillable = [
        "startNodeId",
        "startNodeType",
        "endNodeId",
        "endNodeType",

        "name",
        "coordinates",
        "remarks",
        "cable_length",
        "cable_distance",
        "type",

        "fiber_count",
        "tube_count",
        "cable_type",
    ];

    public function tubes()
    {
        return $this->hasMany(Tube::class);
    }

    public function parentCluster()
    {
        return $this->belongsTo(Cluster::class, "parent_cluster");
    }

    public function startNode()
    {
        return $this->morphTo(null, 'startNodeType', 'startNodeId');
    }

    public function endNode()
    {
        return $this->morphTo(null, 'endNodeType', 'endNodeId');
    }
}
