<?php

namespace App\Http\Controllers\Accounting;

use App\Classes\EditLogHistory;
use Carbon\Carbon;
use App\Models\Expense;
use App\Models\ExpenseHead;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\File;

class ExpenseHeadController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:expense-section',['only' => ['edit','destroy']]);
    }
    public function index()
    {
        $data = [
            'expenseHeads' => ExpenseHead::all(),
        ];
        return view('accounts.expenseHead.index', $data);
    }


    public function create()
    {
        $data = [
            'expenseHeads' => ExpenseHead::get(),
        ];
        return view('accounts.expenseHead.create',$data);
    }


    public function store(Request $request)
    {
        $expense = new ExpenseHead();
        $expense->fill($request->all());
        if ($request->attach_document != null) {
            $fileName = time() . '.' . $request->attach_document->extension();
            $request->attach_document->move(storage_path('app/public/expenseDocument'), $fileName);
            $expense->attach_document = $fileName;
        }
        $expense->save();
        Toastr::success('Expense Head Successfully Saved' ,'Success');
        return redirect()->route('expense-head.create');
    }


    public function show(Expense $expense)
    {
        // return view('accounts.expenseReport.index');
    }


    public function edit($id)
    {

        $expense = ExpenseHead::find($id);

        if($expense->name == 'Salary' || $expense->name == 'House Rent' || $expense->name == 'Office Expense' || $expense->name == 'Electricity Bill' || $expense->name == 'Bandwidth Bill' || $expense->name == 'Reseller Commission' || $expense->name == 'Employee Salary') {
            return redirect()->back()->with('error_message', 'Not Permitted');
        }

        $data = [
            'model' => $expense,
            'title' => 'Expense Head'
        ];
        return view('accounts.expenseHead.edit', $data);
    }


    public function update(Request $request)
    {


        $type = 'Expense Head';
        $old_info = ExpenseHead::where('id', $request->id)->first();

        $expense = ExpenseHead::find($request->id);
        $request->validate([
            //       'teacher_id' => 'required|unique:subjects,name,' . $complain->id,
            // 'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|digits:11|unique:complains,phone,' . $request->id,
        ]);
        $expense->fill($request->all());
        $expense->update();

        $new_info = ExpenseHead::find($expense->id);
        (new EditLogHistory)->editLogSave($expense, $type, $old_info, $new_info);

        Toastr::success('Expense Head Successfully Update' ,'Success');
        return redirect()->route('expense-head.create');
    }


    public function destroy(ExpenseHead $expenseHead)
    {
        // if(!in_array($expenseHead->id,[1,2,3,4,5,6])){

        //     $expenseHead->delete();
        //     return redirect()->route('expense-head.index');
        // }else{
        //     return redirect()->back()->with('error_message','Not Permitted');

        // }
    }
}
