<?php

namespace Database\Seeders;

use App\Models\SmsSetting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SmsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        SmsSetting::truncate();

        $auto_inactive["sms_body"] = "Dear {c_name}\nবিল পরিশোধ না করায় আপনার সংযোগটি বন্ধ হয়ে গেছে । {total_due} টাকা দ্রুত পরিশোধ করুন ।\n\n{company_name}\n{company_cell}";
        $auto_inactive["minimum"] = 50;
        $auto_inactive["sendsms"] = "Yes";

        $myJSON = json_encode($auto_inactive);

        $other_collection["sms_body_for_client"] = "Dear {c_name}\nWe received {PaymentAmount} TK for {BillType}\n\nThanks\n{company_name}\n{company_cell}";
        $other_collection["sms_body_for_extra_income"] = "Dear {Name}\nWe received {PaymentAmount} TK for {BillType}\n\nThanks for your payment\n{company_name}\n{company_cell}";
        $other_collection_json=json_encode($other_collection);

        $support["sms_body_for_client"]="Dear {c_name}\nTicket No: {token_no} (open)\nTo: {department_to}\nSubject: {support_subject}\nWe will knock will soon\n\nThanks\n{company_name}\n{company_cell}";
        $support["sms_body_for_employee"]="Dear {employee_name}\nClient Name:{c_name},{c_number}\nAddress: {c_address}\n{support_subject} (#{token_no})\n{support_massage}";
        $support_json=json_encode($support);

        $bill_generate["sendsms"] ="No";
        $bill_generate["sms_body"] ="Dear {c_name}\n {MonthBillAmount} TK Bill generate for {bill_type}\n\nPlease Pay Before: 05 {ThisMonth}\n\n{company_name}\n{company_cell}";
        $bill_generate_json=json_encode($bill_generate);

        $bill_reminder["second_sendsms"] ="No";
        $bill_reminder["frist_sendsms"] ="No";
        $bill_reminder["frist_sms_body"] ="Dear {c_name}\nLast 2nd day Remaning to Play your internet due bill {TotalDue}Tk\nPlease Pay Your Bill as soon as possible\nThanks\n\n{company_name}\n{company_cell}";
        $bill_reminder["second_sms_body"] ="Dear {c_name}\nLast 1 day Remaning to Play your internet due bill {TotalDue}Tk\nPlease Pay Your Bill as soon as possible\nThanks\n\n{company_name}\n{company_cell}";
        $bill_reminder["first_reminder_day"] =2;
        $bill_reminder["second_reminder_day"] =1;

        $bill_reminder_json=json_encode($bill_reminder);

        $temporary_extended["sendsms"]="No";
        $temporary_extended["sms_body"]="Dear {c_name}\nyour billing date extended to {new_billing_date} please pay in time \nThanks \n{company_name}\n{company_cell}";
        $temporary_extended_jason=json_encode($temporary_extended);

        $expir["sendsms"]="No";
        $expir["sms_body"]="Dear {c_name}\nyour line is exipred please pay your due \nThanks \n{company_name}\n{company_cell}";
        $expir_jason=json_encode($expir);

        $token_create["sendsms"]="No";
        $token_create["sms_body"]="প্রিয় গ্রাহক {c_username}\nআপনার সমস্যাটি আমরা অবগত হয়েছি, আপনার টোকেন আইডি {token_id}\nযে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন |";
        $token_create_jason=json_encode($token_create);

        $pop_expair_exception["sendsms"]="No";
        $pop_expair_exception["sms_body"]="প্রিয় গ্রাহক {c_name} \nবিল পরিশোধ না করার জন্য সাময়িক সময়ের জন্য আপনার সংযোগ টি বিছিন্ন করা হোল। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $pop_expair_exception_jason=json_encode($pop_expair_exception);

        $reseller_customer_recharge["sendsms"]="No";
        $reseller_customer_recharge["sms_body"]="প্রিয় গ্রাহক ({c_name}),\nআপনার {month} মাস পর্যন্ত বিল সঠিক ভাবে সংগৃহিত হয়েছে। {company_name} এর সাথে থাকার জন্য ধন্যবাদ।  যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} এই নাম্বারে|";
        $reseller_customer_recharge_jason=json_encode($reseller_customer_recharge);

        $disable_customer["sendsms"]="No";
        $disable_customer["sms_body"]="প্রিয় গ্রাহক ({c_name}),\nইন্টারনেট বিলের টাকা দেওয়ার সময়সীমা শেষ হওয়ার কারনে সংযোগটি সাময়িক ভাবে বিচ্ছিন্ন হলো। অতিসত্বর বিল পরিশোধ করুন। হেল্পলাইন {company_cell}";
        $disable_customer_jason=json_encode($disable_customer);

        $otc_payment_sms["sendsms"]="No";
        $otc_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে OTC পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $otc_payment_sms_jason=json_encode($otc_payment_sms);

        $package_change_payment_sms["sendsms"]="No";
        $package_change_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে পেকেজ চেঞ্জ এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $package_change_payment_sms_jason=json_encode($package_change_payment_sms);


        $billing_cycle_change_payment_sms["sendsms"]="No";
        $billing_cycle_change_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে বিলিং সাইকেল চেঞ্জ এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $billing_cycle_change_payment_sms_jason=json_encode($billing_cycle_change_payment_sms);

        $new_customer_payment_sms["sendsms"]="No";
        $new_customer_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে নিউ কাস্টমার এন্ট্রি এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $new_customer_payment_sms_jason=json_encode($new_customer_payment_sms);

        $advanced_payment_sms["sendsms"]="No";
        $advanced_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে অ্যাডভান্সড পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $advanced_payment_sms_jason=json_encode($advanced_payment_sms);

        $support_token_create_customer_sms["sendsms"]="No";
        $support_token_create_customer_sms["sms_body"]="প্রিয় গ্রাহক, আপনার সমস্যাটি আমরা অবগত হয়েছি। আপনার টোকেন আইডি {token_no}| যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন";
        $support_token_create_customer_sms_jason=json_encode($support_token_create_customer_sms);

        $support_token_assign_employee_sms["sendsms"]="No";
        $support_token_assign_employee_sms["sms_body"]="Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly";
        $support_token_assign_employee_sms_jason=json_encode($support_token_assign_employee_sms);

        $support_token_assign_customer_sms["sendsms"]="No";
        $support_token_assign_customer_sms["sms_body"]="প্রিয় গ্রাহক, আপনার সমস্যাটি আমরা অবগত হয়েছি। আপনার টোকেন আইডি {token_no}| আপনার সমস্যাটি {employee_name} ({employee_number})সমাধান করবে। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন";
        $support_token_assign_customer_sms_jason=json_encode($support_token_assign_customer_sms);

        $support_token_closed_customer_sms["sendsms"]="No";
        $support_token_closed_customer_sms["sms_body"]="আপনার সমস্যাটি সমাধান হয়েছে। আমরা আপনার টোকেন আইডি {token_no} : {token_code} মুছে ফেলেছি। যদি এখনো সমস্যার সমাধান না হয় তাহলে {company_cell} এই নম্বর এ অভিযোগ করুন।আমাদের সাথে থাকার জন্য ধন্যবাদ।";
        $support_token_closed_customer_sms_jason=json_encode($support_token_closed_customer_sms);

        $support_token_note_add_for_customer_sms["sendsms"]="No";
        $support_token_note_add_for_customer_sms["sms_body"]="{note}| যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
        $support_token_note_add_for_customer_sms_jason=json_encode($support_token_note_add_for_customer_sms);

        $support_token_reassign_employe_sms["sendsms"]="No";
        $support_token_reassign_employe_sms["sms_body"]="Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly";
        $support_token_reassign_employe_sms_json=json_encode($support_token_reassign_employe_sms);

        $reseller_balance_recharge_sms["sendsms"]="No";
        $reseller_balance_recharge_sms["sms_body"]="Dear {reseller_name}\nYour Balance Recharge {recharge_amount}Tk\nYour Current Balance {current_balance}Tk\n\n\nThanks\n{company_name}\n{company_cell}";
        $reseller_balance_recharge_sms_json=json_encode($reseller_balance_recharge_sms);

        $welcome_sms["sendsms"]="No";
        $welcome_sms["sms_body"]="প্রিয় {c_name}\nইউজার আইডি: {c_username}\nপাসওয়ার্ড: {c_password}\nআপনার আইডি সফলভাবে যুক্ত করা হয়েছে। ধন্যবাদ!\n{company_name}\n{company_cell}";
        $welcome_sms_json=json_encode($welcome_sms);

        $monthly_bill_payment_sms["sendsms"]="No";
        $monthly_bill_payment_sms["sms_body"]="প্রিয় গ্রাহক ({c_name}),\nআপনার বিল সঠিক ভাবে সংগৃহিত হয়েছে। সংগৃহিত টাকার পরিমান- TK {PaymentAmount} | যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} | {company_name} এর সাথে থাকার জন্য ধন্যবাদ।";
        $monthly_bill_payment_sms_json=json_encode($monthly_bill_payment_sms);

        $data=[
            [
                'tamplate_name' => 'welcome',
                'tamplate_body' => $welcome_sms_json,
            ],
            [
                'tamplate_name' => 'auto_inactive',
                'tamplate_body' => $myJSON,
            ],
            [
                'tamplate_name' => 'due_bill',
                'tamplate_body' => "Dear {c_name}\nসংযোগ বিচ্ছিন্নকরন এড়াতে\n{c_deadline}-{this_month} তারিখের পূর্বে বিল পরিশোধ করুন ।\nমোট বিলঃ {total_due} টাকা\n\nধ্যনবাদ\n{company_name}\n{company_cell}",
            ],
            [
                'tamplate_name' => 'bill_payment',
                'tamplate_body' => $monthly_bill_payment_sms_json,
            ],
            [
                'tamplate_name' => 'other_collection',
                'tamplate_body' => $other_collection_json,
            ],
            [
                'tamplate_name' => 'support',
                'tamplate_body' => $support_json,
            ],
            [
                'tamplate_name' => 'reseller_payment',
                'tamplate_body' => "{ResellerName}\nজমা: {PaymentAmount} টাকা\nডিস্কাউন্ট: {PaymentDiscount} টাকা\nমোট টাকা: {ColsingBalance} টাকা\n\nThanks\n{company_name}\n{company_cell}",
            ],
            [
                'tamplate_name' => 'bill_generate',
                'tamplate_body' => $bill_generate_json,
            ],
            [
                'tamplate_name' => 'bill_reminder',
                'tamplate_body' => $bill_reminder_json,
            ],
            [
                'tamplate_name' => 'temporary_extended',
                'tamplate_body' => $temporary_extended_jason,
            ],
            [
                'tamplate_name' => 'expired',
                'tamplate_body' => $expir_jason,
            ],
            [
                'tamplate_name' => 'token_create',
                'tamplate_body' => $token_create_jason,
            ],
            [
                'tamplate_name' => 'pop_expair_exception_delete',
                'tamplate_body' => $pop_expair_exception_jason,
            ],
            [
                'tamplate_name' => 'reseller_customer_recharge',
                'tamplate_body' => $reseller_customer_recharge_jason,
            ],
            [
                'tamplate_name' => 'disable_customer_sms',
                'tamplate_body' => $disable_customer_jason,
            ],
            [
                'tamplate_name' => 'otc_payment_sms',
                'tamplate_body' => $otc_payment_sms_jason,
            ],
            [
                'tamplate_name' => 'package_change_payment_sms',
                'tamplate_body' => $package_change_payment_sms_jason,
            ],
            [
                'tamplate_name' => 'billing_cycle_change_payment_sms',
                'tamplate_body' => $billing_cycle_change_payment_sms_jason,
            ],
            [
                'tamplate_name' => 'new_customer_payment_sms',
                'tamplate_body' => $new_customer_payment_sms_jason,
            ],
            [
                'tamplate_name' => 'advanced_payment_sms',
                'tamplate_body' => $advanced_payment_sms_jason,
            ],
            [
                'tamplate_name' => 'token_create_customer_sms',
                'tamplate_body' => $support_token_create_customer_sms_jason,
            ],[
                'tamplate_name' => 'token_assign_employee_sms',
                'tamplate_body' => $support_token_assign_employee_sms_jason,
            ],[
                'tamplate_name' => 'token_assign_customer_sms',
                'tamplate_body' => $support_token_assign_customer_sms_jason,
            ],[
                'tamplate_name' => 'token_close_customer_sms',
                'tamplate_body' => $support_token_closed_customer_sms_jason,
            ],[
                'tamplate_name' => 'token_note_customer_sms',
                'tamplate_body' => $support_token_note_add_for_customer_sms_jason,
            ],[
                'tamplate_name' => 'token_reassign_employee_sms',
                'tamplate_body' => $support_token_reassign_employe_sms_json,
            ],[
                'tamplate_name' => 'reseller_balance_recharge_sms',
                'tamplate_body' => $reseller_balance_recharge_sms_json,
            ],
        ];

        foreach($data as $item){
            if(SmsSetting::where('tamplate_name',$item["tamplate_name"])->first() == null){
                DB::table('sms_settings')->insert([
                    'tamplate_name' => $item["tamplate_name"],
                    'tamplate_body' => $item["tamplate_body"],

                ]);
            }
        }

    }
}
