<?php

namespace App\Http\Controllers;

use App\Models\TokenCat;
use Illuminate\Http\Request;

class TokenCatController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:token-category', ['only' => ['index']]);

    }

    public function index()
    {
        $categoty=TokenCat::all();
        return view('tokenCategory.index', [
            'categoty' => $categoty,
            // 'page_title' => 'Support',
            // 'add_button' => 'true',
            // 'url' => route('tokenCat.create'),
            // 'class' => 'btn btn-success form-control',
            // 'value' => 'Add New Token Category',
            // 'width' => 'col-md-2'
        ]);
    }


    public function create()
    {
        return view('tokenCategory.create');
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'tokenCategory' => 'required|unique:token_cats'
        ]);

        $tokenCat = new TokenCat();
        $tokenCat->fill($request->all());
        $tokenCat->save();
        return redirect()->route('tokenCat.index')->with('success_message', 'Token Category Added Successufll');

    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $tokenCat = TokenCat::find($id);
        return view('tokenCategory.edit', ['tokenCat' => $tokenCat]);
    }


    public function update(Request $request, $id)
    {
        $tokenCat = TokenCat::find($id);
        $this->validate($request, [
            'tokenCategory' => ['required', 'unique:token_cats,tokenCategory,' . $tokenCat->id],
        ]);

        $tokenCat->fill($request->all());
        $tokenCat->update();
        return redirect()->route('tokenCat.index')->with('success_message', 'Token Category Update Successufll');
    }


    public function destroy($id)
    {
        $tokenCat = TokenCat::find($id);
        $tokenCat->delete();
        return redirect()->route('tokenCat.index');
    }
}
