@extends('layout.app')
@section('content')
    <div class="d-flex justify-content-start flex-column align-items-start">
        <h3 class="text-space"><strong>Mikrotik Name : </strong> {{ $mikrotik->shortname }}</h3>

        <h3 class="text-space"><strong>Mikrotik IP : </strong> {{ $mikrotik->nasname }}</h3>

    </div>
    <hr>
    @php
        $emoji = ['success' => '✔️', 'danger' => '❌', 'warning' => '⚠️'];
    @endphp
    @foreach ($result as $item)
        <p class="h5 py-1 text-{{ $item['status'] }} text-bold text-space"> {{ $emoji[$item['status']] }}
            {{ $item['message'] }}</p>
    @endforeach
@endsection


<style>
    .content-wrapper {
        background: inherit !important;
    }

    .text-space {
        letter-spacing: 0.025em;
        line-height: 1.75rem;
        color: #78716c;
    }
</style>





