<?php $__env->startSection('content'); ?>



    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date"  class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller" id="reseller" class="select2 form-control">
                                <option value="">Select One</option>
                                <?php $__currentLoopData = $reseller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select POP
                        </label>
                        <select name="pop" id="pop" class="form-control select2">
                            <option value=""> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

                

            </form>


        </div>
    </div>


    <div class="mt-2 card">

        <div class="card-body result" id="deactiveResult">
            <div class="row">
                <?php if(checkSettings('deactive-custome-datatable') != 'enable'): ?>
                    <div class="col-md-6 pagination">
                        <?php echo e($list->onEachSide(1)->links()); ?>

                    </div>
                <?php endif; ?>

                <div class="col-md-4">
                    <?php if(isset($print_url) && !empty($print_url)): ?>
                        <a href="<?php echo e(route($print_url)); ?>" target="_blank"><i class="fa fa-print"></i></a>
                    <?php endif; ?>
                </div>
            </div>

            <div id="processing">
                <div>Processing.....</div>
            </div>

            <div id="customer_list_body">
                <p class=" p-1 float-right" style="border:2px solid #fed7aa; ">Total Result: <?php echo e((checkSettings('deactive-custome-datatable') == 'enable') ? $list->count() : $list->total()); ?></p>
                <?php echo $__env->make('clients.customer_search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

        </div>

    </div>
    <div class="card-footer">
    </div>
</div>

<style>
    div#processing {
        display: none;
    }

    div#processing div {
        background: rgba(0, 0, 0, .5);
        position: fixed;
        width: 100vw;
        height: 100vh;
        color: #fff;
        text-align: center;
        vertical-align: middle;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    @media  print {
        a {
            text-decoration: none !important;
            color: #222 !important;
        }

        th {
            font-size: 10px !important;
            padding: 2px !important;
            text-align: center;
        }

        tr {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        td {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        table {
            width: 100%;
        }

        .shadow {
            box-shadow: none;
        }

        tr th:last-child {
            display: none !important;
        }

        tr td:last-child {
            display: none !important;
        }

    }

</style>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>

<script type="text/javascript">
    $(function() {
        $('#reset').click(function() {
            $('#deactiveResult').html('');
            $('#pop').html('<option value="all">Select One</option>');
        });

        $('#searchBtn').on('click', function(e) {
            e.preventDefault();
            // $('body').append('<div id="processing">processing.....</div>');
            $('body').prepend('<div id="loading">Loading.....</div>');
            $.ajax({
                type: 'get',
                url: '<?php echo e(route('deactiveCustomerSearch')); ?>',
                data: $('#search').serialize(),
                success: function(result) {
                    // console.log(result);
                    $('#deactiveResult').html(result);
                    $('#processing').remove();
                    $('#loading').remove();
                }
            });
        });


        $('#reseller').on('change', function(e) {
            e.preventDefault();
            $('body').append('<div class="hidden" id="processing">processing.....</div>');

            $.ajax({
                type: 'get',
                url: '<?php echo e(route('getResellerPopList')); ?>',
                data: {
                    id: $(this).val()
                },
                success: function(result) {
                    $('#pop').html(result);
                    $('#processing').remove();
                }
            });
        });

    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/khokon/radius-circle/resources/views/deactiveList/deactive.blade.php ENDPATH**/ ?>