@extends('layout.app')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    Payment Getway
                    <button type="button" class="btn btn-primary btn-sm float-right" data-toggle="modal"
                        data-target="#paymentGetway">Add Payment Getway</button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataTable" class="display table">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th>Id</th>
                                    <th>Payment Getway</th>
                                    <th>App Key / Public Key</th>
                                    <th>Secret Key / Private Key</th>
                                    <th>Username / Merchantid</th>
                                    <th>Password / Merchant Number</th>
                                    <th>Base Url</th>
                                    <th>Callback Url</th>
                                    <th>Payer Reference</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach ($paymentgetways as $paymentgetway)
                                    <tr>
                                        <td>{{ $paymentgetway->id }}</td>
                                        <td>{{ $paymentgetway->getway_name }}</td>
                                        <td>{{ $paymentgetway->appkey_publickey }}</td>
                                        <td>{{ $paymentgetway->secretkey_privatekey }}</td>
                                        <td>{{ $paymentgetway->username_merchantid }}</td>
                                        <td>{{ $paymentgetway->password_merchantnumber }}</td>
                                        <td>{{ $paymentgetway->base_url }}</td>
                                        <td>{{ $paymentgetway->callback_url }}</td>
                                        <td>{{ $paymentgetway->payer_reference }}</td>
                                        <td>
                                            <a href="{{ route('paymentGetwayEdit', $paymentgetway->id) }}"
                                                class="btn btn-primary btn-sm">Edit</a>
                                            <a href="{{ route('paymentGetwayDelete', $paymentgetway->id) }}"
                                                class="btn btn-danger btn-sm">Delete</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="paymentGetway">
        <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Payment Getway Add</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <form method="POST" action="{{ route('paymentGetwayStore') }}">
                                    @csrf
                                    <input type="hidden" name="reseller_id" value="{{ $reseller_id }}">
                                    <div class="form-group">
                                        <label for="paymentgetway">Payment Getway</label>
                                        <select name="getway_name" class="form-control">
                                            <option value="">Select Payment Getway</option>
                                            <option value="bkash">Bkash</option>
                                            <option value="nagad">Nagad</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>App Key / Public Key</label>
                                        <input type="text" name="appkey_publickey" class="form-control"
                                            placeholder="Enter App Key / Public Key">
                                    </div>

                                    <div class="form-group">
                                        <label>Secret Key / Private Key</label>
                                        <input type="text" name="secretkey_privatekey" class="form-control"
                                            placeholder="Enter Secret Key / Private Key">
                                    </div>

                                    <div class="form-group">
                                        <label>Username / Merchantid</label>
                                        <input type="text" name="username_merchantid" class="form-control"
                                            placeholder="Enter Username / Merchantid">
                                    </div>

                                    <div class="form-group">
                                        <label>Password / Merchant Number</label>
                                        <input type="text" name="password_merchantnumber" class="form-control"
                                            placeholder="Enter Password / Merchant Number">
                                    </div>

                                    <div class="form-group">
                                        <label>Base Url</label>
                                        <input type="text" name="base_url" class="form-control"
                                            placeholder="Enter Password / Merchant Number">
                                    </div>

                                    <div class="form-group">
                                        <label>Callback Url</label>
                                        <input type="text" name="callback_url" class="form-control"
                                            placeholder="Enter Callback Url">
                                    </div>

                                    <div class="form-group">
                                        <label>Payer Reference</label>
                                        <input type="text" name="payer_reference" class="form-control"
                                            placeholder="Enter Payer Reference">
                                    </div>

                            </div>
                        </div>

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary" type="submit">Add Payment
                            Getway</button>
                    </div>


            </form>


        </div>
    </div>
    <!-- /.modal-dialog -->
    </div>
@endsection
