@extends('Customer.customer-layout')


@section('body')
    @include('Customer.left-menu')
 
    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Packages</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">packages</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
        <section class="section profile">
            <div class="row">

                <div class="col-xl-8">

                    <div class="card">
                        <div class="card-body pt-3">
                            <!-- Bordered Tabs -->

                            <div class="tab-content pt-2">

                                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                                    <h5 class="card-title">Package Details</h5>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Subscriber ID</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['userinfo']->id }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE NAME</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['package']->package_name ?? '' }} </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">STATUS</div>
                                        <div class="col-lg-9 col-md-8">
                                            @if ($details['userinfo']->clients_status == 'expired')
                                                <button
                                                    class="btn-danger">{{ $details['userinfo']->clients_status }}</button>
                                            @else
                                                <button
                                                    class="btn-primary">{{ $details['userinfo']->clients_status }}</button>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE PRICE</div>
                                        <div class="col-lg-9 col-md-8">{{ $details['package']->package_rate ?? '' }}</div>
                                    </div>


                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">EXPIRE DATE</div>
                                        <div class="col-lg-9 col-md-8">
                                            {{ date('d-M-Y', strtotime($details['userinfo']->expire_date)) }}</div>
                                    </div>



                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>

                </div>
        </section>

    </main>
@endsection