<?php

namespace App\Jobs;

use App\Http\Controllers\RadiusLogController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class StoreClientDownLoadUploadJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $get_clients;
    public function __construct($clients)
    {
        $this->get_clients = $clients;
        // dd($this->get_clients);
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        (new RadiusLogController())->saveRadiusLogToClientTable($this->get_clients);
    }
}
