@php
    
    session([
        'pendingCustomer' => TopmenuService::countPendingCustomer(),
        'newCustomer' => TopmenuService::countNewCustomer(),
        'deactivatedCustomer' => TopmenuService::deactivatedCustomer(),
        'expiredCustomer' => TopmenuService::countExpiredCustomer(),
        'allCustomer' => TopmenuService::countAllcustomer(),
    ]);
    
@endphp



<x-top-navbar>
    <nav class="noprint bg-gray-800 fixed top-0 w-full z-50" id="nav">
        <div class="mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <x-application-logo style="width:50px;" />
                    </div>
                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">
                            <ul class="flex justify-between" id="menuPc">


                                <li>

                                    <x-Custom.navLink navLinkUrl="{{ route('dashboard') }}"
                                        isActive="{{ Request::path() === 'dashboard' ? 'bg-gray-900' : '' }}"
                                        class="inline-block" navLinkName="Dashboard" />

                                </li>

                                {{-- @can('reseller-menu-view') --}}

                                <li>
                                    <x-Custom.dropDownMenu navTitle="Manager" iconName="table">

                                        <ul class="menu">
                                            @can('reseller_index')
                                                <li>
                                                    <div class="flex justify-between"><span>Manager</span> <span>
                                                            <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                        </span>
                                                    </div>
                                                    <ul class="submenu">
                                                        <li>
                                                            @can('reseller_index')
                                                                <a href="{{ route('resellers.index') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Reseller List</a>
                                                            @endcan

                                                        </li>
                                                        <li>

                                                            @can('reseller_create')
                                                                <a href="{{ route('resellers.create') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Add New
                                                                    Reseller</a>
                                                            @endcan
                                                        </li>
                                                    </ul>

                                                </li>
                                            @endcan
                                            @can('pop_index')
                                                <li>
                                                    <div class="flex justify-between"><span>POP</span> <span>
                                                            <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                        </span>
                                                    </div>
                                                    <ul class="submenu">
                                                        <li>
                                                            @can('pop_index')
                                                                <a href="{{ route('pop.index') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Pop/Zone List</a>
                                                            @endcan

                                                        </li>
                                                        <li>

                                                            @can('pop_create')
                                                                <a href="{{ route('pop.create') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Add
                                                                    New Pop/Zone</a>
                                                            @endcan
                                                        </li>

                                                        <li>
                                                            @can('pop_exception')
                                                                <a href="{{ route('pop.exception') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Experity
                                                                    Exception</a>
                                                            @endcan
                                                        </li>
                                                    </ul>
                                                </li>
                                            @endcan
                                            @can('package_index')
                                                <li>

                                                    <div class="flex justify-between"><span>Package</span> <span>
                                                            <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                        </span>
                                                    </div>
                                                    <ul class="submenu">
                                                        <li>
                                                            @can('package_index')
                                                                <a href="{{ route('packages.index') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Packages List</a>
                                                            @endcan
                                                        </li>
                                                        <li>
                                                            @can('package_create')
                                                                <a href="{{ route('packages.create') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Add New
                                                                    Packages</a>
                                                            @endcan

                                                        </li>
                                                    </ul>


                                                </li>
                                            @endcan
                                            <li>
                                                <div class="flex justify-between"><span>Sub Reseller Package</span>
                                                    <span>
                                                        <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                    </span>
                                                </div>
                                                <ul class="submenu">
                                                    <li>
                                                        @can('sub-package_index')
                                                            <a href="{{ route('sub-packages.index') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Sub Packages
                                                                List</a>
                                                        @endcan
                                                    </li>
                                                    <li>
                                                        @can('sub-package_create')
                                                            <a href="{{ route('sub-packages.create') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Add New Sub
                                                                Packages</a>
                                                        @endcan
                                                    </li>
                                                </ul>
                                            </li>
                                            @can('mikrotik_index')
                                                <li>
                                                    <div class="flex justify-between"><span>Mikrotik</span> <span>
                                                            <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                        </span>
                                                    </div>
                                                    <ul class="submenu">
                                                        <li>
                                                            @can('mikrotik_index')
                                                                <a href="{{ route('mikrotiks.index') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Mikrotik List</a>
                                                            @endcan
                                                        </li>
                                                        <li>
                                                            @can('mikrotik_create')
                                                                <a href="{{ route('mikrotiks.create') }}"
                                                                    class="py-2 px-5 block hover:bg-gray-200">Add New
                                                                    mikrotik</a>
                                                            @endcan

                                                        </li>
                                                    </ul>
                                                </li>
                                            @endcan
                                            <li>
                                                <div class="flex justify-between"><span>User</span> <span>
                                                        <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                    </span>
                                                </div>
                                                <ul class="submenu">

                                                    <li>
                                                        @can('mac-customer_index')
                                                            <a href="{{ route('clients.index') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Customer List
                                                            </a>
                                                        @endcan

                                                    </li>
                                                    <li>
                                                        @can('mac-customer_create')
                                                            <a href="{{ route('clients.create') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Add New
                                                                Customer</a>
                                                        @endcan

                                                    </li>

                                                    <li>
                                                        @can('onlineUser')
                                                            <a href="{{ route('onlineCustomer') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Online
                                                                Customer</a>
                                                        @endcan
                                                    </li>

                                                    <li>
                                                        @can('oflineUser')
                                                            <a href="{{ route('oflineCustomer') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Ofline
                                                                Customer</a>
                                                        @endcan

                                                    </li>

                                                    <li>
                                                        @can('customer-search-report')
                                                            <a href="{{ route('clientSearch') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Customer
                                                                Search</a>
                                                        @endcan
                                                    </li>

                                                    <li>
                                                        @can('changePackage')
                                                            <a href="{{ route('packageChange') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Package Change</a>
                                                        @endcan
                                                    </li>

                                                    <li>
                                                        @can('changeBillCycle')
                                                            <a href="{{ route('billingCycleChange') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Billing Cycle
                                                                Change</a>
                                                        @endcan
                                                    </li>

                                                    <li>
                                                        @can('deactivated-customer_index')
                                                            <a href="{{ route('deactivatedClients') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Deactivated
                                                                Customer List

                                                            </a>
                                                        @endcan
                                                    </li>


                                                </ul>
                                            </li>
                                        </ul>

                                    </x-Custom.dropDownMenu>


                                </li>

                                {{-- @endcan --}}

                                {{-- @can('customer-menu-view') --}}
                                <li>
                                    <x-Custom.dropDownMenu navTitle="Customer" iconName="users">

                                        <ul class="menu pl-4">
                                            <li>
                                                <div class="flex justify-between"><span>Token</span> <span>
                                                        <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                    </span>
                                                </div>
                                                <ul class="submenu">
                                                    <li>
                                                        @can('token-category')
                                                            <a href="{{ route('tokenCat.index') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Token Category</a>
                                                        @endcan
                                                    </li>
                                                    <li>
                                                        @can('token-code')
                                                            <a href="{{ route('tokenCode.index') }}"
                                                                class="py-2 px-5 block hover:bg-gray-200">Token Code</a>
                                                        @endcan
                                                    </li>
                                                    <li>
                                                        {{-- @can('assign-token') --}}
                                                        <a href="{{ route('token.index') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Token List</a>
                                                        {{-- @endcan --}}
                                                    </li>
                                                </ul>

                                            </li>
                                        </ul>


                                        @can('assign-token')
                                            <a href="{{ route('assignTokenList') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Assign Token
                                            </a>
                                        @endcan
                                        {{-- <a href="{{ route('assignTokenList')}}" class="py-2 px-5 block hover:bg-gray-200">Assign
                                        Token List
                                        </a> --}}
                                        {{-- @endcan('newjoin') --}}
                                        @can('close-token')
                                            <a href="{{ route('closeTokenList') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Close Token
                                            </a>
                                        @endcan
                                        {{-- <a href="{{ route('closeTokenList')}}" class="py-2 px-5 block hover:bg-gray-200">Close
                                        Token List
                                        </a> --}}
                                        <a href="{{ route('printTokenList') }}" target="blank"
                                            class="py-2 px-5 block hover:bg-gray-200">Print Token
                                        </a>
                                        @can('token-search')
                                            <a href="{{ route('searchToken') }}" target="blank"
                                                class="py-2 px-5 block hover:bg-gray-200">Search
                                                Token
                                            </a>
                                        @endcan


                                        {{-- @can('customer-support') --}}
                                        <a href="{{ route('support-home') }}"
                                            class="py-2 px-5 block hover:bg-gray-200">
                                            Support Home
                                        </a>
                                        {{-- @endcan --}}
                                        @can('login-attempts-all')
                                            <a href="{{ route('login-attempts-all') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">
                                                Login Attempts All
                                            </a>
                                        @endcan
                                        <a href="{{ route('pendingCustomer') }}"
                                            class="py-2 px-5 block hover:bg-gray-200">
                                            Pending Customer List
                                            <span
                                                class="bg-red-600 rounded-full text-white py-0 px-2">{{ session('pendingCustomer') }}</span>

                                        </a>





                                        @can('expire-customer')
                                            <a href="{{ route('expiredClients') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Expired Customer List

                                            </a>
                                        @endcan

                                        @can('monthly-paid-customer-list')
                                            <a href="{{ route('monthlyPaidCustomer') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Monthly Paid Customer List

                                            </a>
                                        @endcan












                                        @can('newjoin')
                                            <a href="{{ route('newJoin') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">New
                                                Customer
                                                <span
                                                    class="bg-green-600 rounded-full text-white py-0 px-2">{{ session('newCustomer') }}</span>
                                            </a>
                                        @endcan('newjoin')





                                    </x-Custom.dropDownMenu>
                                </li>
                                {{-- @endcan --}}

                                @can('account-menu-view')
                                    <li>
                                        <x-Custom.dropDownMenu navTitle="Accounts" iconName="dollar-sign">
                                            @can('money-receipt-entry')
                                                <a href="{{ route('billCollection') }}"
                                                    class="py-2 px-5 block hover:bg-gray-200">Bill Collection</a>
                                            @endcan
                                            @can('extra')
                                                @can('income-section')
                                                    <h4 class="py-2 px-5 block bg-gray-100 text-center">Income</h4>

                                                    @can('other-income')
                                                        <a href="#" class="py-2 px-5 block hover:bg-gray-200">Other Income</a>
                                                    @endcan

                                                @endcan

                                                @can('expense-section')
                                                    <h4 class="py-2 px-5 block bg-gray-100 text-center">Expense</h4>
                                                    @can('account-head')
                                                        <a href="#" class="py-2 px-5 block hover:bg-gray-200">Account Head</a>
                                                    @endcan
                                                    @can('expense-entry')
                                                        <a href="#" class="py-2 px-5 block hover:bg-gray-200">Expense</a>
                                                    @endcan

                                                @endcan


                                                @can('expense-section')
                                                    <h4 class="py-2 px-5 block bg-gray-100 text-center">Balance Sheet</h4>

                                                    <a href="#" class="py-2 px-5 block hover:bg-gray-200">Account
                                                        Statment</a>
                                                @endcan

                                            @endcan

                                        </x-Custom.dropDownMenu>

                                    </li>

                                @endcan
                            </ul>

                        </div>
                    </div>
                </div>
                <div class="md:block">


                    <div class="ml-4 flex items-center md:ml-6">

                        {{-- @can('report-menu-view') --}}

                        <x-Custom.dropDownMenu navTitle="Reports" iconName="table">
                            @can('reseller-recharge-report')
                                <a href="{{ route('resellerRechargeReport.index') }}"
                                    class="py-2 px-5 block hover:bg-gray-200">Reseller Recharge Report</a>
                            @endcan
                            @can('sub-reseller-recharge-report')
                                <a href="{{ route('subResellerRechargeReport.index') }}"
                                    class="py-2 px-5 block hover:bg-gray-200">Sub-Reseller Recharge Report</a>
                            @endcan

                            @can('reseller-balance-log-report')
                                <a href="{{ route('ReselleBalanceLog.index') }}"
                                    class="py-2 px-5 block hover:bg-gray-200">Reseller Balance Log Report</a>
                            @endcan
                            {{-- @can('sub-reseller-balance-log-report') --}}
                            <a href="{{ route('subResellerBalanceLog.index') }}"
                                class="py-2 px-5 block hover:bg-gray-200">Sub-Reseller Balance Log Report</a>
                            {{-- @endcan --}}
                            <hr>
                            {{-- <a href="{{route('user.index') }}" class="py-2 px-5 block hover:bg-gray-200">Client Due
                            Report</a> --}}
                            @can('bill-sheet')
                                <a href="{{ route('billSheet') }}" class="py-2 px-5 block hover:bg-gray-200">Bill
                                    Sheet</a>
                            @endcan
                            @can('payment-report')
                                <a href="{{ route('paymentReport') }}" class="py-2 px-5 block hover:bg-gray-200">Payment
                                    Report</a>
                            @endcan
                            @can('money-receipt-search')
                                <a href="{{ route('moneyReceiptSearch') }}" class="py-2 px-5 block hover:bg-gray-200">MR
                                    Search</a>
                            @endcan


                            {{-- <a href="{{route('managerBalance') }}" class="py-2 px-5 block
                            hover:bg-gray-200">Manager Balance Report</a> --}}
                            <a href="{{ route('clientSearchBTRC') }}"
                                class="py-2 px-5 block
                            hover:bg-gray-200">BTRC Customer
                                List</a>

                            </x-Custom.dorpDownMenu>

                            {{-- @endcan --}}

                            @can('inventory_store')

                                <x-Custom.dropDownMenu navTitle="Store" iconName="archive">

                                    @can('requisition_approve')
                                        <a href="{{ route('requisition.pending') }}"
                                            class="py-2 px-5 block hover:bg-gray-200">Pending Requisition
                                        </a>
                                    @endcan
                                    @can('requisition_index')
                                        <a href="{{ route('requisition.index') }}"
                                            class="py-2 px-5 block hover:bg-gray-200">Requisition List
                                        </a>
                                    @endcan
                                    @can('requisition_index')
                                        <a href="{{ route('requisition.create') }}"
                                            class="py-2 px-5 block hover:bg-gray-200">Add New Requisition
                                        </a>
                                    @endcan
                                    <hr>
                                    <a href="{{ route('stock.index') }}" class="py-2 px-5 block hover:bg-gray-200">Stock
                                    </a>
                                    <a href="{{ route('purchase.index') }}"
                                        class="py-2 px-5 block hover:bg-gray-200">Purchase
                                    </a>
                                    <hr>
                                    <ul class="menu pl-4">
                                        <li>
                                            <div class="flex justify-between"><span>Branch</span> <span>
                                                    <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                </span>
                                            </div>
                                            <ul class="submenu">
                                                <li>
                                                    <a href="{{ route('branch.create') }}"
                                                        class="py-2 px-5 block hover:bg-gray-200">Branch
                                                        Create</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('branch.index') }}"
                                                        class="py-2 px-5 block hover:bg-gray-200">Branch
                                                        View</a>

                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <div class="flex justify-between"><span>Item</span> <span>
                                                    <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                </span>
                                            </div>
                                            <ul class="submenu">
                                                <li>
                                                    @can('inventory_create')
                                                        <a href="{{ route('item.create') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Item
                                                            Create</a>
                                                    @endcan
                                                </li>
                                                <li>
                                                    @can('inventory_index')
                                                        <a href="{{ route('item.index') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Item
                                                            View</a>
                                                    @endcan
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <div class="flex justify-between"><span>Item Category</span> <span>
                                                    <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                </span>
                                            </div>
                                            <ul class="submenu">
                                                <li>
                                                    @can('inventory-group_create')
                                                        <a href="{{ route('item-category.create') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Item Category Create</a>
                                                    @endcan
                                                </li>
                                                <li>
                                                    @can('inventory-group_index')
                                                        <a href="{{ route('item-category.index') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Item Category View</a>
                                                    @endcan
                                                </li>
                                            </ul>
                                        </li>
                                        <li>
                                            <div class="flex justify-between"><span>Unit</span> <span>
                                                    <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                </span>
                                            </div>
                                            <ul class="submenu">
                                                <li>
                                                    @can('unit_create')
                                                        <a href="{{ route('unit.create') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">unit Create</a>
                                                    @endcan
                                                </li>
                                                <li>
                                                    @can('unit_index')
                                                        <a href="{{ route('unit.index') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">unit
                                                            View</a>
                                                    @endcan
                                                </li>
                                            </ul>
                                        </li>

                                        <li>
                                            <div class="flex justify-between"><span>Supplier</span> <span>
                                                    <x-Custom.chevronTop style="transform:rotate(-90deg)" />
                                                </span>
                                            </div>
                                            <ul class="submenu">
                                                <li>
                                                    @can('supplier_create')
                                                        <a href="{{ route('supplier.create') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Supplier Create</a>
                                                    @endcan
                                                </li>
                                                <li>
                                                    @can('supplier_index')
                                                        <a href="{{ route('supplier.index') }}"
                                                            class="py-2 px-5 block hover:bg-gray-200">Supplier
                                                            View</a>
                                                    @endcan
                                                </li>

                                            </ul>

                                        </li>
                                    </ul>


                                    <hr>
                                    </x-Custom.dorpDownMenu>

                                @endcan



                                @can('refresh')
                                    <a href="{{ route('refresh_session') }}"
                                        class="py-2 px-5 block hover:bg-gray-200">Refresh Session</a>
                                @endcan


                                @can('admin-menu-view')
                                    <x-Custom.dropDownMenu navTitle="Admin" iconName="cogs">


                                        @can('user-registration')
                                            <a href="{{ route('user.create') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">New
                                                Users</a>
                                        @endcan

                                        @can('user_index')
                                            <a href="{{ route('user.index') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">View
                                                Users</a>
                                            <hr>
                                        @endcan
                                        @can('user-registration')
                                            <a href="{{ route('employees.create') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">New
                                                Employee</a>
                                        @endcan

                                        @can('user_index')
                                            <a href="{{ route('employees.index') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">View
                                                Employees</a>
                                            <hr>
                                        @endcan

                                        @can('role_create')
                                            <a href="{{ route('roles.create') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Create
                                                Role</a>
                                        @endcan
                                        @can('role_index')
                                            <a href="{{ route('roles.index') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">View
                                                Role</a>
                                            <hr>
                                        @endcan
                                        @can('permission_create')
                                            <a href="{{ route('permissions.create') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">Create
                                                Permission</a>
                                        @endcan
                                        @can('permission_index')
                                            <a href="{{ route('permissions.index') }}"
                                                class="py-2 px-5 block hover:bg-gray-200">View
                                                Permission</a>
                                        @endcan
                                        </x-Custom.dorpDownMenu>
                                    @endcan


                                    <x-Custom.dropDownMenu navTitle="{{ Auth::user()->name }}"
                                        iconName="circle-user">

                                         <a href="{{ route('user.edit', Auth::user()->id) }}"
                                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 bg-red-900"
                                            role="menuitem">Edit Profile</a> 

                                        @can('password-change')
                                            <a href="{{ route('passwordReset', Auth::user()->id) }}"
                                                class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100"
                                                role="menuitem">Pasword Change</a>
                                        @endcan

                                        <a href="#"
                                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100"
                                            role="menuitem">Settings</a>

                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <x-responsive-nav-link :href="route('logout')"
                                                onclick="event.preventDefault();
                                    this.closest('form').submit();">
                                                {{ __('Logout') }}
                                            </x-responsive-nav-link>
                                        </form>


                                    </x-Custom.dropDownMenu>

                    </div>
                </div>

                <div :class="{ 'flex': open, 'hidden': !open }" class="flex md:hidden">
                    <div @click.away="open = false" class="relative" x-data="{ open: false }">


                        <button @click="open = !open"
                            class="bg-gray-800 inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-white hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-white">
                            <span class="sr-only">Open main menu</span>
                            <!--
            Heroicon name: menu
            Menu open: "hidden", Menu closed: "block"
          -->
                            <svg class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <!--
            Heroicon name: x
            Menu open: "block", Menu closed: "hidden"
          -->
                            <svg class="hidden h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>

                        <div x-show="open" class="absolute right-0  mt-2 origin-top-right" style="width:90vw">

                            <div class="box-border px-2 pt-2 pb-4 bg-white rounded-md shadow-lg dark-mode:bg-gray-700">
                                <div class="dropdown-item" id="mMenu">



                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

</x-top-navbar>
<style>
    /* since nested groupes are not supported we have to use
     regular css for the nested dropdowns
  */
    li>ul {
        transform: translatex(100%) scale(0)
    }

    li:hover>ul {
        transform: translatex(101%) scale(1)
    }

    li>button svg {
        transform: rotate(-90deg)
    }

    li:hover>button svg {
        transform: rotate(-270deg)
    }

    /* Below styles fake what can be achieved with the tailwind config
     you need to add the group-hover variant to scale and define your custom
     min width style.
  See https://codesandbox.io/s/tailwindcss-multilevel-dropdown-y91j7?file=/index.html
  for implementation with config file
  */
    .group:hover .group-hover\:scale-100 {
        transform: scale(1)
    }

    .group:hover .group-hover\:-rotate-180 {
        transform: rotate(180deg)
    }

    .scale-0 {
        transform: scale(0)
    }

    .min-w-32 {
        min-width: 8rem
    }

    .submenu {
        box-shadow: 0 0 3px 1px #ddd;
    }

    @media (max-width:600px) {
        div#mMenu li div span {
            color: #000;
        }

        #mMenu button svg {
            color: #000;
        }

        #mMenu li {
            list-style: none;
        }

        #mMenu button {
            background: none;
        }
    }



    /*
/////////////////// */
    /* .dropdown:hover .dropdown-menu {
        display: block;
    } */
</style>
