<div class="print-content" id="result">

    <table class="table table-bordered table-condensed table-striped" id="tableId">
        <thead class="bg-dark text-white">
            <tr>
                <th>Serial Number</th>
                <th>KAM Name</th>
                <th>New Id (Active)</th>
                <th>Updated Id (Active)</th>
                <th>New Id (Not Active)</th>
                <th>Updated Id (Not Active)</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @php
                use App\Models\Pop;
                $sumOfNewClients = 0;
                $sumOfUpdatedClients = 0;
                $total_resellers = 0;

                $sumOfNewClientsNotActive = 0;
                $sumOfUpdateClientsNotActive = 0;
            @endphp
            @foreach ($users as $user)
                @php
                    $all_resellers_ids = $user->resellers()->count();
                    $new_resellers_ids = $user->resellers()
                                                ->whereBetween('resellers.created_at', [$start, $end])
                                                ->pluck('resellers.id');
                    $new_pops = Pop::whereIn('reseller_id', $new_resellers_ids)->pluck('id');
                    $old_resellers_ids = $user->resellers()
                                            ->whereNotIn('resellers.id', $new_resellers_ids)
                                            ->pluck('resellers.id');
                    $old_pops = Pop::whereIn('reseller_id', $old_resellers_ids)->pluck('id');
                    $new_active_clients = $clients->whereIn('pop_id', $new_pops)->where('clients_status', 'active')->count();
                    $updated_active_clients = $clients->whereIn('pop_id', $old_pops)->where('clients_status', 'active')->count();

                    $new_not_active_clients = $clients->whereIn('pop_id', $new_pops)->where('clients_status', '!=', 'active')->count();
                    $updated_not_active_clients = $clients->whereIn('pop_id', $old_pops)->where('clients_status', '!=', 'active')->count();

                    $sumOfNewClientsNotActive += $new_not_active_clients;
                    $sumOfUpdateClientsNotActive += $updated_not_active_clients;

                    $sumOfNewClients += $new_active_clients;
                    $sumOfUpdatedClients += $updated_active_clients;
                    $total_resellers += $all_resellers_ids;
                @endphp
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $user->name }} ({{$all_resellers_ids}}) </td>
                    <td>{{ $new_active_clients }}</td>
                    <td>{{ $updated_active_clients }}</td>
                    <td>{{ $new_not_active_clients }}</td>
                    <td>{{ $updated_not_active_clients }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="2"><b>Total ({{$sumOfNewClients + $sumOfUpdatedClients}}) ({{$total_resellers}})</b></td>
                <td><b>{{ $sumOfNewClients }}</b></td>
                <td><b>{{ $sumOfUpdatedClients }}</b></td>
                <td><b>{{ $sumOfNewClientsNotActive }}</b></td>
                <td><b>{{ $sumOfUpdateClientsNotActive }}</b></td>
            </tr>
        </tbody>
    </table>
</div>
