<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApiBandwidthUsagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('api_bandwidth_usages', function (Blueprint $table) {
            $table->id();
            $table->string('session_id');
            $table->string('username');
            $table->string('ip_address')->nullable();
            $table->string('mac_address')->nullable();
            $table->decimal('uploaded', 20, 2)->default(0);
            $table->decimal('downloaded', 20, 2)->default(0);
            $table->dateTime('session_start_time');
            $table->dateTime('session_end_time')->nullable();
            $table->string("last_disconnect_reason")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_bandwidth_usages');
    }
}
