@php
$enablecustomer = 0;
$disablecustomer = 0;
$activecustomer = 0;
$packagecount = [];
@endphp

<div class="">
    <div class=" card">
        <div class="card-body">
            <form action="{{ route('CustomerRecharge') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="text-center">
                                        <input type="checkbox" id="allSelect">
                                    </th>
                                    <th class="">ID</th>
                                    <th>User name</th>
                                    <th>Status</th>
                                    <th>Expire Date</th>
                                    <th>Bill Cycle</th>
                                    <th>Package</th>
                                    <th>Package price</th>
                                    <th>POP</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Contact No</th>
                                    <th>Connection Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach ($list as $r)

                                    <tr>


                                        <td class="text-center">
                                            @if ($r->bill_generate != 'yes')

                                                <input type="checkbox" value="{{ $r->id }}"
                                                    class="checkbox" id="row_id" name="ids[]">

                                                @if (auth()->user()->hasRole(['Reseller Admin', 'Admin']))

                                                    <input type="hidden" name="price[]" class="current_price"
                                                        value="{{ $r->package_rate }}">

                                                @elseif(auth()->user()->hasRole(['Sub Reseller']))

                                                    <input type="hidden" name="price[]" class="current_price"
                                                        value="{{ $r->sub_package_rate }}">

                                                @endif


                                            @endif



                                        </td>
                                        <td> {{ $r->id }}
                                        </td>
                                        <td>
                                            {{ $r->userid }}


                                            @can('ppp-password')
                                                <br>
                                                {{ $r->password }}
                                            @endcan
                                        </td>

                                        @if ($r->clients_status == 'expired')
                                            <td class="deactive bg-danger">
                                                Expired

                                            @elseif($r->clients_status == 'deactive')
                                            <td class="deactive bg-danger">
                                                Deactive

                                            @elseif($r->clients_status == 'disable')
                                            <td class="bg-warning">
                                                Disable

                                            @elseif($r->clients_status == 'active')
                                            <td class="bg-success">
                                                Active

                                            @elseif($r->client_approval == 'pending')
                                            <td>
                                                Pending
                                        @endif
                                        </td>

                                        @if ($r->clients_status == 'expired')
                                            <td class="bg-danger whitespace-nowrap">
                                                {{ date('d-M-Y', strtotime($r->expire_date)) }}
                                            </td>
                                        @else
                                            <td class="bg-success whitespace-nowrap">
                                                {{ date('d-M-Y', strtotime($r->expire_date)) }}
                                            </td>
                                        @endif

                                        <td>
                                            {{ $r->billing_cycle }}
                                        </td>

                                        <td>

                                            @if (!empty($r->sub_package_name))
                                                @can('show-sub-package')
                                                    {{ $r->sub_package_name }}
                                                @endcan
                                            @else
                                                @can('show-mother-package')
                                                    {{ $r->package_name }}
                                                @endcan
                                            @endif
                                        </td>

                                        <td>
                                            @if (!empty($r->sub_package_rate))

                                                @can('show-sub-package-rate')
                                                    {{ $r->sub_package_rate }}
                                                @endcan

                                            @else

                                                @can('show-motherpackage-rate')
                                                    {{ $r->package_rate }}
                                                @endcan

                                            @endif



                                        </td>


                                        <td>

                                            {{ $r->popname }}

                                        </td>

                                        <td>
                                            {{ $r->clients_name }}
                                        </td>

                                        <td style="max-width:250px;">
                                            <p style="font-size:12px;">Flat No: {{ $r->flat_no ?? '' }} ,
                                                Building Name: {{ $r->building_name ?? '' }} ,
                                                Road No: {{ $r->road_no ?? '' }} ,
                                                Block/Sector: {{ $r->block_sector ?? '' }} ,
                                                Area : {{ $r->area ?? '' }} </p>
                                        </td>

                                        <td>
                                            {{ $r->contact_no ?? '' }}
                                        </td>


                                        <td class="whitespace-nowrap">
                                            {{ date('d-M-Y', strtotime($r->created_at)) }}
                                        </td>




                                        <td class="text-center noprint" style="width:160px;">
                                            <a href="{{ route('clients.show', $r->client_id) }}"
                                                class="btn btn-secondary btn-block btn-xs">Details</a>

                                            @can('mac-customer_edit')
                                                <a href="{{ route('clients.edit', $r->id) }}"
                                                    class="btn btn-primary btn-block inline-block btn-xs">Edit</a>
                                            @endcan

                                            <div class="mb-1"></div>




                                            @can('customer-recharge')

                                                @if ($r->clients_status != 'deactive')

                                                    @if ($r->clients_status == 'disable')
                                                        @can('id-enable')
                                                            <a href="{{ route('idEnable', $r->client_id) }}"
                                                                onclick="return confirm('Are you sure you want to Enable the ID?');"
                                                                class="btn btn-success btn-block btn-xs">Enable</a>

                                                        @endcan
                                                    @elseif($r->clients_status != 'disable')
                                                        @can('id-disable')
                                                            <a href="{{ route('idDisable', $r->client_id) }}"
                                                                onclick="return confirm('Are you sure you want to Disable the ID?');"
                                                                class="confirmDisable btn btn-warning btn-block btn-xs">Disable</a>

                                                        @endcan
                                                    @endif

                                                @elseif($r->clients_status == 'deactive')
                                                    @can('customer-reactivate')
                                                        <a href="{{ route('statusChange', ['reactive', $r->id]) }}"
                                                            onclick="return confirm('Are you sure you want to Reactive the ID?');"
                                                            class="btn btn-success btn-block btn-xs">Reactive</a>
                                                    @endcan
                                                @endif





                                                

                                            @endcan                                      

                                        </td>

                                    </tr>
                                @endforeach


                                <tr>
                                    <td colspan="15">
                                        <p class="text-center">

                                            Total Customer: {{ $list->count() }} |
                                            Total Active: {{ $activecustomer }} |
                                            Total Expired: {{ $list->where('clients_status', 'expired')->count() }} |
                                            Total Disable: {{ $list->where('clients_status', 'disabled')->count() }}
                                            |
                                            Total Disable: {{ $list->where('clients_status', 'deactive')->count() }}


                                        </p>
                                    </td>
                                </tr>

                                <tr>
                                    <td colspan="15">
                                        <p class="text-center">
                                            {!! $packages_count !!}
                                        </p>



                                    </td>
                                </tr>


                                <!-- More items... -->
                            </tbody>
                        </table>
                    </div>

                    <div id="balanceHints">
                        <table class="table table-auto">

                            @if (auth()->user()->hasRole(['Reseller Admin', 'Admin']))
                                @foreach ($reseller as $item)
                                    <tr>

                                        <td>Balance:</td>
                                        <td>{{ $item->balance[0]['amount'] ?? 0 }}</td>
                                    </tr>
                                @endforeach
                            @elseif(auth()->user()->hasRole(['Sub Reseller']))
                                @foreach ($pop as $item)
                                    <tr>

                                        <td>Balance:</td>
                                        <td>{{ $item->balance[0]['amount'] ?? 0 }}</td>
                                    </tr>
                                @endforeach
                            @endif
                            <tr>
                                <td>Cost:</td>
                                <td><span id="selected_user_price" readonly></span></td>
                            </tr>

                        </table>

                    </div>

                </div>
                <div class="row">
                    <table class="table">
                        <tr>


                            <td>
                                <label for="recharge" class="float-right">
                                    <input id="recharge" type="radio" value="Recharge" name="type" required> Recharge
                                </label>

                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="billingCycleChange" class="d-none">
                                    <input id="billingCycleChange" type="radio" value="billingCycleChange" name="type"
                                        required> Billing Cycle Change
                                </label>
                            </td>
                        </tr>

                        <tr>
                            <td colspan="2">
                                <button class="btn btn-primary float-right" type="submit">Submit</button>
                            </td>
                        </tr>



                    </table>



                </div>

                <div class="block pt-10 pr-5">
                    <div class="float-right block">


                    </div>
                </div>

                <div class="form-group">


                </div>

            </form>

            {{-- <div class="p-5">
                        {{ $list->links() }}
        </div> --}}
        </div>
    </div>
</div>
</div>
</div>
<style>
    #balanceHints {
        position: fixed;
        width: 200px;
        z-index: 99;
        background: skyblue;
        bottom: 10px
    }

</style>

<script>
    $(function() {
        total = 0;
        $('#allSelect').on('click', function() {
            total = 0;
            resellerBalance = $('#resellerBalance').text();
            if (this.checked) {
                $('.checkbox').each(function() { //loop through each checkbox
                    $(this).prop('checked', true); //check 
                    let price = $(this).parent('td').find('.current_price').val();
                    total += parseInt(price);
                });
            } else {
                $('.checkbox').each(function() { //loop through each checkbox
                    $(this).prop('checked', false); //uncheck    
                    let price = $(this).parent('td').find('.current_price').val();
                    total -= parseInt(price);
                });
                total = 0;
            }
            $('#selected_user_price').text(total);
        });
        $('.checkbox').on('change', function() {
            // var id = $(this).val();
            if (this.checked) {
                //$(this).prop('checked', true);
                let price = $(this).parent('td').find('.current_price').val();
                total += parseInt(price);
                $('#selected_user_price').text(total);
            } else {
                //$(this).prop('checked', false);
                let price = $(this).parent('td').find('.current_price').val();
                total -= parseInt(price);
                $('#selected_user_price').text(total);
            }
        });
    });
</script>





<script>
    $(document).ready(function() {
        var total = 0;
        $('.checkbox').on('click', function() {
            // var id = $(this).val();
            var currentRow = $(this).closest("tr");
            var package_rate = currentRow.find("td:eq(7)").text();
            if (this.checked) {
                $('#selected_user_price').each(function() { //loop through each checkbox
                    // $(this).val(id); //check 
                    total += parseInt(package_rate);
                    $(this).val(total);
                });
            } else {
                $('#selected_user_price').each(function() { //loop through each checkbox
                    // $(this).val(id); //check 
                    total -= parseInt(package_rate);
                    $(this).val(total);
                });
            }
        });
    });
</script>
