<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCableMap extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cable_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->foreignId("startNodeId")->nullable();
            $table->enum("startNodeType", ["cluster", "tjBox"])->nullable();

            $table->foreignId("endNodeId")->nullable();
            $table->enum("endNodeType", ["cluster", "tjBox"])->nullable();

            $table->string("name");
            $table->json("coordinates");
            $table->string("type")->default("cable");
            $table->integer("cable_length");
            $table->integer("cable_distance");
            $table->longText("remarks")->nullable();

            $table->integer("fiber_count");
            $table->integer("tube_count");
            $table->enum("cable_type", ["tight-buffered", "loose-tube-buffered"]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cable_map');
    }
}
