<?php

namespace App\Classes\MikrotikService\MikrotikStaticIPLogic;

use RouterOS\Query;

trait QueueStaticIP
{
    public function getQueues($filedName = null, $targetIpAddress = null)
    {
        $queueQuery = new Query("/queue/simple/print");

        if ($filedName && $targetIpAddress) {
            $queueQuery->where($filedName, $targetIpAddress);
        }

        $queueResponse = $this->runQuery($queueQuery);

        if (sizeof($queueResponse) === 0) {
            $anotherQ = new Query("/queue/simple/print");
            $anotherQ->where("target", "$targetIpAddress/32");
            $queueResponse = $this->runQuery($anotherQ);
            if (sizeof($queueResponse)) {
                return ($filedName && $targetIpAddress) ? $queueResponse[0] : $queueResponse;
            }
            return null;
        }
        return ($filedName && $targetIpAddress) ? $queueResponse[0] : $queueResponse;
    }

    public function createQueue($queueInfo)
    {
        $queueQuery = new Query("/queue/simple/add");

        $this->queryMapper($queueQuery, $queueInfo);

        $queueResponse = $this->runQuery($queueQuery);

        return $queueResponse;
    }

    public function updateQueue($queueName, $queueInfo)
    {
        $queueQuery = new Query("/queue/simple/set");
        $existingQueue = $this->getQueues("target", $queueName);

        $queueQuery->equal("numbers", $existingQueue[".id"]);
        $this->queryMapper($queueQuery, $queueInfo);

        $queueResponse = $this->runQuery($queueQuery);

        return $queueResponse;
    }

    public function deleteQueue($queueName)
    {
        $queueQuery = new Query("/queue/simple/remove");

        $existingQueue = $this->getQueues("target", $queueName);

        $queueQuery->equal("numbers", $existingQueue[".id"]);

        $queueResponse = $this->runQuery($queueQuery);

        return $queueResponse;
    }
}
