@can('dashboard-billing-info')
    @if (getBillingType() == 'day_to_day')
        <div class="card">
            <div class="card-body">
                <section class="bill-collection-area bg-white pt-2  mt-2 mb-2 pb-2">
                    <h4 class="text-center my-2">Manager (only Own) Approximate Bill
                        {{ date('M') }} {{ date('Y') }}</h4>
                    <table class="table table-hover table-responsive-lg">
                        <thead>
                            <tr>
                                <th scope="col" class="h6">Manager Name</th>
                                <th scope="col" class="h6 text-right">Approximate Monthly Bill</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $this_month_bill = 0;
                            @endphp

                            @foreach ($localApproxBill as $item)
                                @php
                                    $bill = 0;
                                    foreach ($item as $r) {
                                        $bill += $r->total_client * $r->package_rate;
                                    }
                                @endphp

                                <tr>
                                    <td class="h6">{{ $item->first()->name }}</td>
                                    <td class="text-right">{{ $bill }}</td>
                                </tr>

                                @php
                                    $this_month_bill += $bill;
                                @endphp
                            @endforeach

                            <tr class="bg-gray">
                                <td class="h6">Total</td>
                                <td class="h6 text-right">{{ $this_month_bill }}</td>
                            </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>
    @endif
@endcan
