@extends('layout.app')


@section('content')
    <form action="{{ route('crm-item-return-save') }}" method="POST">

        @csrf
        <div class="card">
            <div class="card-body">
                <a class="btn bg-purple" href="{{ route('crm-list', "Fiber") }}">Back To CRM </a>
                <br>
                <span class="text-danger text-md badge"> Note : Here, we show only those items that are not approved by Store Admin.</span>

                <div style="width: 50%; margin: 0 auto; text-align: center;">
                    <label for="item_id" style="display: block; margin-bottom: 5px;">
                        Select Item
                    </label>

                    <select name="item_id" id="item_id" style="width: 50%; height: 40px; box-sizing: border-box; padding: 8px; border: 1px solid #ccc; border-radius: 4px; font-size: 14px; color: #555; background-color: #fff;">
                        <option value="">Select One</option>
                        @foreach ($crm_items as $item)
                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                        @endforeach
                    </select>
                </div>
                <input type="hidden" id="client_id" name="client_id" value="{{$client_id}}">

                <table class="table table-bordered mt-3">
                    <thead class="table-dark">
                        <tr>
                            <th style="width: 40%">Item Name</th>
                            <th style="width: 20%">Quantity</th>
                            <th>Return Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="item_list">
                        @foreach ($crm_return_items as $key=>$item)

                            <tr>
                                <td >
                                    {{$item->item->name}}
                                    <input type="hidden" name="item_id[]" id="item_id" value="{{$item->crm_item_id}}" required class="form-control" placeholder=" Name" autocomplete="off">
                                </td>
                                <td >
                                    <input type="number" step=".01" name="item_quantity[]" id="item_quantity" value="{{$item->quantity}}" min="1" required class="form-control" placeholder="Quantity" autocomplete="off">
                                </td>
                                <td>
                                    <select name="item_return_status[]" id="item_return_status" class="form-control" required>
                                        <option value="Good" @if ($item->status == 'Good') selected  @endif>Good</option>
                                        <option value="Damage" @if ($item->status == 'Damage') selected  @endif>Damage</option>
                                        <option value="Lost" @if ($item->status == 'Lost') selected  @endif>Lost</option>
                                    </select>
                                </td>

                                <td>
                                    <button type="button" class="btn btn-danger btn-sm remove_item @if ($item->approve_status == "Approve") d-none @endif" >
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="form-group">
                    <button type="submit" class="btn btn-success float-right">
                        Save
                    </button>
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>
    <style>
        .form-control {
           width: auto !important
        }

        .card{
            width: auto !important;
        }
    </style>
@endsection

@push('js')

    <script>
        $(document).ready(function() {
            $(document).on("change", "#item_id", function() {

                var item_id = $(this).val();
                var item_name = $("#item_id option:selected").text();

                if(item_id){

                    let row = ` <tr>
                                <td >
                                    ${item_name}
                                    <input type="hidden" name="item_id[]" id="item_id" value="${item_id}" required class="form-control" placeholder=" Name" autocomplete="off">
                                </td>
                                <td >
                                    <input type="number" step=".01" name="item_quantity[]" id="item_quantity" value="1" min="1" required class="form-control" placeholder="Quantity" autocomplete="off">
                                </td>
                                <td>
                                    <select name="item_return_status[]" id="item_return_status" class="form-control" required>
                                        <option value="Good">Good</option>
                                        <option value="Damage">Damage</option>
                                        <option value="Lost">Lost</option>
                                    </select>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm remove_item" >
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>`;

                    $("#item_list").append(row);
                }

            });

            $(document).on("click", ".remove_item", function() {
                $(this).closest("tr").remove();
            });


       });
    </script>
@endpush
