<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-customer-amount')): ?>
                <a href="#" class="noprint btn btn-info">Total Customer: <?php echo e($list->count()); ?></a>
                <a href="#" class="noprint btn btn-info">Total Amount:
                    <?php echo e($list->map(function ($item) {return $item->customerAccount->dueAmount;})->sum()); ?></a>
            <?php endif; ?>
            <button type="submit" class="btn btn-info float-right mb-2">
                <a class="text-white" href="<?php echo e(route('billCollectionPrint')); ?>" target="blank"> Print</a>
            </button>


            <div class="table-responsive">
                <table id="dataTable" class="display ">
                    <thead class="bg-gray-50">
                        <tr>
                            <th style="display: none">Invoice</th>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Status</th>
                            <th>Name</th>
                            <th>Contact</th>
                            <th>Address</th>
                            <th>Zone/POP</th>
                            <th>Package</th>
                            <th style="width:100px">Exp. Date</th>
                            
                            <th>OTC</th>
                            <th>Pre_Due</th>
                            <th>Bill</th>
                            <th>Total_Due</th>
                            <th>

                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">

                        <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="display: none">
                                    <a href="<?php echo e(route('severalPrint', $r->id)); ?>"> <i class="fa fa-print"></i> </a>
                                </td>
                                <td>
                                    <a class="underline text-blue-300"
                                        href="<?php echo e(route('getPaymentHistory', $r->id)); ?>"><?php (printf('CID%04d', $r->id)); ?></a>

                                    <a href="<?php echo e(route('invoice', $r->id)); ?>" class="btn btn-info btn-xs">Invoice</a>
                                </td>
                                <td>
                                    <?php echo e($r->userid); ?>

                                </td>
                                <td class="cStatus<?php echo e($r->id); ?> <?php echo e(clientStatusClass($r->clients_status)); ?>">
                                    <?php if($r->clients_status == 'active'): ?>
                                        Active
                                    <?php elseif($r->clients_status == 'deactive'): ?>
                                        Deactive</span>
                                    <?php elseif($r->clients_status == 'expired'): ?>
                                        Expired</span>
                                    <?php elseif($r->clients_status == 'disable'): ?>
                                        Disabled</span>
                                    <?php endif; ?>
                                </td>
                                <td class="whitespace-nowrap">
                                    <?php echo e($r->clientsinfo->clients_name ?? ''); ?>


                                </td>


                                <td>
                                    <?php echo e($r->clientsinfo->contact_no ?? ''); ?>

                                </td>

                                <td>
                                    Flat No: <?php echo e($r->clientsinfo->flat_no ?? ''); ?> ,
                                    Building Name: <?php echo e($r->clientsinfo->building_name ?? ''); ?> ,
                                    Road No: <?php echo e($r->clientsinfo->road_no ?? ''); ?> ,
                                    Block/Sector: <?php echo e($r->clientsinfo->block_sector ?? ''); ?> ,
                                    Area : <?php echo e($r->clientsinfo->area ?? ''); ?>


                                </td>

                                <td style="width:100px;">
                                    <?php echo e($r->pop->popname); ?>

                                </td>

                                <td style="width:100px;">
                                    <?php echo e($r->packages->package_name); ?>

                                </td>

                                <td class="whitespace-nowrap" style="width:100px">
                                    <?php echo e(date('d-M-Y', strtotime($r->expire_date))); ?> <br>

                                    <?php if($r->payment_dadeline != 0): ?>
                                        <span class="d-block badge badge-warning">
                                            Exp Extend:
                                            <?php echo e(\Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y')); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>

                                
                                <td style="text-align: right"><?php echo e($r->clientsinfo->otc_due); ?></td>

                                <td style="text-align: right">
                                    <?php if($r->customerAccount->dueAmount - $r->packages->package_rate > 0): ?>
                                        <?php echo e($r->customerAccount->dueAmount - $r->packages->package_rate); ?>

                                    <?php else: ?>
                                        <?php echo e(0); ?>

                                    <?php endif; ?>


                                </td>
                                <td style="text-align: right">
                                    <?php echo e($r->packages->package_rate); ?>

                                </td>
                                <td style="text-align: right">
                                    <?php echo e($r->customerAccount->dueAmount); ?>

                                </td>



                                <td class="px-6 text-center text-sm font-medium">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_create')): ?>
                                        <?php if($r->customerAccount->dueAmount >= $r->packages->package_rate): ?>
                                            
                                        <?php endif; ?>
                                    <?php endif; ?>


                                    

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('money-receipt-entry')): ?>
                                        

                                        <a href="<?php echo e(route('getPaymentHistory', $r->id)); ?>"
                                            class="btn btn-primary btn-block">Payment</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>



        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        $(document).ready(function() {

            $('.singlePayment').on('click', function(e) {
                e.preventDefault();
                var id = $(this).data('id');

                if (confirm('Are you Confirm! You want to pay the bill!')) {
                    $('body').append('<div id="loading">Processing.....</div>');
                    $.ajax({
                        type: 'POST',
                        url: '<?php echo e(route('singlePayment')); ?>',
                        data: $(this.form).serialize(),
                        dataType: 'json',
                        success: function(data) {
                            if (data.status == 'error') {
                                $('#loading').remove();
                                $('body').append(data.message);
                            }
                            if (data.status == 'success') {
                                $('#loading').remove();
                                $('body').append(data.message);
                                // console.log(data.message);

                                $('.btn' + id).remove();
                            }
                        }
                    });

                }

            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/extranet/radius-circle/resources/views/billing/pendingBill.blade.php ENDPATH**/ ?>