<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerBillPayment;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ResellerAccountReportController extends Controller
{
    public function resellerCustomerPaymentReport()
    {
        $reseller = $this->getOtherResellerForAuthUser();
        $resellerPaymentReportUser = ResellerBillPayment::whereIn('reseller_id', $reseller->pluck('id'))
                                    ->distinct('user_id')
                                    ->pluck('user_id')
                                    ->toArray();

        $users = User::whereIn('id', $resellerPaymentReportUser)->get();

        $data = [
            'reseller' => $reseller,
            'end' => now()->endOfMonth(),
            'start' => now()->startOfMonth(),
            'users' => $users,
        ];

        return view('report.resellerClientAccount.paymentReport.report', $data);


    }

    public function resellerPaymentReportSearch(Request $request)
    {
        $start = Carbon::parse($request->from_date)->format('Y-m-d 00:00:00');
        $end = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');

        $resellerBillPayment = ResellerBillPayment::query()
            ->whereBetween('created_at', [$start, $end]);

        if ($request->reseller_id) {
            $resellerBillPayment->where('reseller_id', $request->reseller_id);
        } else {
            $resellerIds = $this->getOtherResellerForAuthUser()->pluck('id');
            $resellerBillPayment->whereIn('reseller_id', $resellerIds);
        }

        if ($request->user_by) {
            $resellerBillPayment->where('user_id', $request->user_by);
        }

        if ($request->pop_id) {
            $resellerBillPayment->where('pop_id', $request->pop_id);
        }

        $payments = $resellerBillPayment
            ->with('reseller', 'paymentBy', 'client', 'clientsInfo')
            ->orderBy('created_at', 'desc')
            ->get();

        $data = [
            'payments' => $payments,
        ];
        return view('report.resellerClientAccount.paymentReport.search', $data);
    }

    public function resellerDueCustomerList()
    {
        $reseller = $this->getOtherResellerForAuthUser();
        $popIds = Pop::whereIn('reseller_id', $reseller->pluck('id'))->pluck('id');


        $clients = Client::list()->where('customer_account_balance_reseller', '>', 0)
            ->whereIn('pop_id',$popIds)->get();
        $areas = Clientsinfo::whereIn('client_id', $clients->pluck('id'))
            ->distinct('area')
            ->pluck('area');

        $data = [
            'reseller' => $reseller,
            'clients' => $clients,
            'areas' => $areas,
        ];

        return view('report.resellerClientAccount.dueReport.report', $data);
    }

    public function resellerClientDueReportSearch(Request $request)
    {
        // dd($request->all());
        if($request->reseller_id){


            if($request->pop_id){
                $popIds = Pop::where('id', $request->pop_id)->pluck('id');
            }else{
                $popIds = Pop::where('reseller_id', $request->reseller_id)->pluck('id');
            }
            $clients = Client::list()->where('customer_account_balance_reseller', '>', 0)
                ->whereIn('pop_id',$popIds);
        }else{
            $reseller = $this->getOtherResellerForAuthUser();
            $popIds = Pop::whereIn('reseller_id', $reseller->pluck('id'))->pluck('id');
            $clients = Client::list()->where('customer_account_balance_reseller', '>', 0)
                ->whereIn('pop_id',$popIds);
        }

        if ($request->area) {
            $clients->whereHas('clientsinfo', function ($q) use ($request) {
                return $q->where('area', $request->area);
            });
        }
        $start = Carbon::parse($request->expire_date)->format('Y-m-d 00:00:00');
        $end = Carbon::parse($request->expire_date)->format('Y-m-d 23:59:59');

        if($request->expire_date){
            $clients->whereBetween('expire_date', [$start, $end]);
        }

        $data = [
            'clients' => $clients->get(),
        ];
        return view('report.resellerClientAccount.dueReport.search', $data);

    }


    public function getOtherResellerForAuthUser()
    {
        $resellersIds = Reseller::resellerList()->pluck('id');

        $ownMangers = Reseller::where('reseller_type', 'other')->whereIn('id', $resellersIds)->get();

        return $ownMangers;
    }
}
