import { createSlice } from '@reduxjs/toolkit';

const initialState = {
    clusters: [],
};

const reducers = {
    setClusters(state, action) {
        state.clusters = action.payload;
        return state;
    },
    addCluster(state, action) {
        state.clusters.push(action.payload);
        return state;
    },

    deleteCluster(state, action) {
        state.clusters = state.clusters.filter(
            (cluster) => cluster.id !== action.payload
        );
        return state;
    },
};

const clustersReducer = createSlice({
    name: 'clusters',
    initialState,
    reducers,
});

export const { setClusters, addCluster, deleteCluster } =
    clustersReducer.actions;

export default clustersReducer.reducer;
