import Map from "./components/Map/Map";
import EditablePolyline from "./components/Polylines/EditablePolyline/EditablePolyline";
import { Toaster } from "react-hot-toast";

import Submit from "./components/Forms/Submit";
import BackButton from "./components/shared/BackButton/BackButton";

import "./App.css";
import "bootstrap/dist/css/bootstrap.min.css";
import PrintAllNode from "./components/Polylines/PrintAllNode";
import SelectedNodes from "./components/shared/SelectedNodes/SelectedNodes";
import ToggleButton from "./components/shared/DrawButton/DrawButton";
import { BoxUserSearch } from "./components/shared/BoxUserSearch/BoxUserSearch";
import { LocateCoordinateBox } from "./components/shared/LocateCoordinate/LocateCoordinateBox";
import { LocateCoordinateMarker } from "./components/shared/LocateCoordinate/LocateCoordinateMarker";

const App = () => {
    return (
        <>
            <Toaster position="top-center" />
            <BackButton />
            <Submit />
            <ToggleButton />
            <SelectedNodes />
            <BoxUserSearch />
            <LocateCoordinateBox />
            <Map>
                <EditablePolyline />
                <PrintAllNode />
                <LocateCoordinateMarker />
            </Map>
        </>
    );
};

export default App;
