<?php

namespace App\Http\Controllers;

use App\Models\Nas;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class NasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $this->validate(
            $request,
            [
                'shortname' => 'required',
                'nasname' => 'required|unique:nas,nasname',
                'secret' => 'required',
                'description' => 'required'
            ],
            [
                'nasname.unique' => 'The Mikrotik Ip has already been taken.',
                'nasname.required' => 'The Mikrotik Ip field is Required',
                'shortname.required' => 'Mikrotik Name field Is Required'
            ]
        );

        $result = Nas::create([
            'nasname'       => $request->nasname,
            'shortname'     => $request->shortname,
            'secret'        => $request->secret,
            'description'   => $request->description,
            'type'          => 'other'
        ]);

        exec('/usr/bin/sudo /etc/init.d/freeradius restart');

        $request->session()->flash('success_message', 'Mikrotik Added successfull');
        return redirect()->route('mikrotiks.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {


        // dd($request->all());
        $this->validate(
            $request,
            [
                'shortname' => 'required',
                'nasname' => 'required|unique:nas,nasname,' . $id,
                'secret' => 'required',
                'description' => 'required'
            ],
            [
                'nasname.unique' => 'The Mikrotik Ip has already been taken.',
                'nasname.required' => 'The Mikrotik Ip field is Required',
                'shortname.required' => 'Mikrotik Name field Is Required'
            ]
        );

        $nas = Nas::find($id);

        $nas->nasname = $request->nasname;
        $nas->shortname = $request->shortname;
        $nas->secret = $request->secret;
        $nas->description = $request->description;



        $nas->update();
        // Nas::where('id',$id)->update([
        //     'nasname'      => $request->nasname,
        //     'shortname'    => $request->shortname,
        //     'secret'       => $request->secret,
        //     'description'  => $request->description


        // ]);


        exec('/usr/bin/sudo /etc/init.d/freeradius restart');

        $request->session()->flash('success_message', 'Mikrotik Update successfull');

        return redirect()->route('mikrotiks.index');
    }

    public function duplicateRadiusUserPass()
    {

        echo 'Remove Duplicate Password';
        
        $users = DB::table('radcheck')
            ->where('attribute', 'Cleartext-Password')
            ->groupBy('username')
            ->havingRaw('COUNT(*) > 1')
            ->pluck('username');        

        $list = DB::table('radcheck')
            ->whereIn('username', $users)
            ->where('attribute', 'Cleartext-Password')
            ->orderBy('username', 'asc')
            ->get()
            ->groupBy('username');

        foreach($list as $l){
            echo $l[0]->username;
            echo '<br>';
            echo $l[1]->username;
            echo '<br>';


            DB::table('radcheck')
                ->where('id',$l[1]->id)
                ->delete();
        }

        echo "<br>".'Remove NAS-IP-Address';

        // NAS-IP-Address

        $users = DB::table('radcheck')
            ->where('attribute', 'NAS-IP-Address')
            ->groupBy('username')
            ->havingRaw('COUNT(*) > 1')
            ->pluck('username');        

        $list = DB::table('radcheck')
            ->whereIn('username', $users)
            ->where('attribute', 'NAS-IP-Address')
            ->orderBy('username', 'asc')
            ->get()
            ->groupBy('username');      


        foreach($list as $l){
            echo $l[0]->username;
            echo '<br>';
            echo $l[1]->username;
            echo '<br>';

            DB::table('radcheck')
                ->where('id',$l[1]->id)
                ->delete();
        }
            

        
    }
}
