@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('global-settings.store') }}" method="POST">

                @csrf

              <div class="row">
                <div class="form-group col-md-4">
                    <label for="name">
                        Global Settings Name*
                    </label>

                    <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control "
                        placeholder="Global Settings Name" autocomplete="off">

                    @error('name')
                        <div class="alert alert-danger">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-4">
                    <label for="status" class="block text-sm font-medium text-gray-700">
                        Status*
                    </label>


                    <select name="status" id="status" class="select2 form-control">
                        <option value="">Select Status</option>
                        <option value="enable">Enable</option>
                        <option value="disable">disable</option>
                    </select>
                    @error('status')
                        <div class="alert alert-danger">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
              </div>
                <div class="form-group col-md-10">

                    <a href="{{ route('global-settings.index') }}" class="btn-default btn"> <i
                            class="fa fa-arrow-left"></i> Back to Global Settings List</a>

                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
