import React from 'react';
import { Form } from 'react-bootstrap';

function SelectDevice(props) {
  return (
    <Form.Group className='mt-2'>
      <Form.Label>Select Device</Form.Label>
      <Form.Select onChange={props.onComponentChangeHandler}>
        <option>select device</option>
        {props.devices?.map((device) => (
          <option value={device.id} key={device.id}>
            {device.id}: {device.name} - {device.manufactures} - {device.model}
          </option>
        ))}
      </Form.Select>
    </Form.Group>
  );
}

function SelectSplitter(props) {
  return (
    <Form.Group className='mt-2'>
      <Form.Label>Select Splitter</Form.Label>
      <Form.Select onChange={props.onComponentChangeHandler}>
        <option>Select Splitter</option>
        {props.splitters.map((splitter) => (
          <option value={splitter.id} key={splitter.id}>
            {splitter.id}: {splitter.name} - 1:{splitter.split_ratio} - used:
            {splitter.used}
          </option>
        ))}
      </Form.Select>
    </Form.Group>
  );
}

export function Components({
  componentOption,
  onComponentChangeHandler,
  devices,
  splitters,
  onus,
}) {
  switch (componentOption) {
    case 'device':
      return (
        <SelectDevice
          onComponentChangeHandler={onComponentChangeHandler}
          devices={devices}
        />
      );

    case 'splitter':
      return (
        <SelectSplitter
          onComponentChangeHandler={onComponentChangeHandler}
          splitters={splitters}
        />
      );

    case 'onu':
      return (
        <Form.Group className='mt-2'>
          <Form.Label>Select Onu</Form.Label>
          <Form.Select onChange={onComponentChangeHandler}>
            <option>Select Onu</option>
            {onus.map((onu) => (
              <option value={onu.id} key={onu.id}>
                {onu.id}: {onu.name} - {onu.manufactures} - {onu.model}
              </option>
            ))}
          </Form.Select>
        </Form.Group>
      );

    default:
      return null;
  }
}
