<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Banking;

class Income extends Model
{
    use HasFactory;
    protected $fillable=[
        'name',
        'incomeHead',
        'invoice_number',
        'date',
        'amount',
       // 'attach_document',
        'description',
        'bank_account_id',
    ];

    public function head(){
        return $this->belongsTo(IncomeHead::class, 'incomeHead', 'id');
    }

    public function bankAccount(){
        return $this->belongsTo(Banking::class, 'bank_account_id');
    }
}
