<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use App\Models\Pop;
use App\Models\Reseller;

class LeftClientController extends Controller
{
    public function leftClient(){

        // $list = Client::list();



        // $list->onlyTrashed()->orWhere(function ($query) {
        //     $query->Where('clients_status', 'deactive')
        //         ->whereIn('pop_id', userPops()->pluck('id'));
        // });


        $data_deactive = Client::list()->where('clients_status', 'deactive');
        $data_delete = Client::list()->onlyTrashed();


        return view('clients.leftclient', [
            'page_title' => 'Left Customer List',
            'reseller'   =>  Reseller::resellerList()->get(),
            // 'list'       => $list->get(),
            'deactiveCount'   =>  $data_deactive->count(),
            'deleteCount'     =>  $data_delete->count(),
            'deactive'   => $data_deactive->get(),
            'delete'     => $data_delete->get(),
        ]);
    }

    public function leftClientSearch(Request $request){

        if ($request->ajax()) {

            // dd($request->all());

            $poplist = Pop::with('reseller')->where('reseller_id', $request->reseller)->get();
            $pop_ids = $poplist->pluck('id')->toArray();
            $pops = Pop::where('id', $request->pop)->get();
            $data_deactive = [];
            $data_delete = [];
            // dd($pop_ids, $pops);
            if ($request->reseller != null && $request->pop == 'all') {
                //for all pop of a reseller
               $data_deactive = Client::list()->where('clients_status', 'deactive')->whereIn('pop_id', $pop_ids);
               $data_delete = Client::list()->onlyTrashed()->whereIn('pop_id', $pop_ids);
                // dd($list->get());
            } else if ($request->reseller != null && $request->pop != null) {
                //for single pop

                foreach ($pops as $key => $pop) {
                    $data_deactive = Client::list()->where('clients_status', 'deactive')->where('pop_id', $pop->id);
                    $data_delete = Client::list()->onlyTrashed()->where('pop_id', $pop->id);

                }
            } else {

                //for all pop of all reseller
                $data_deactive = Client::list()->where('clients_status', 'deactive');
                $data_delete = Client::list()->onlyTrashed();
            }

            // dd($data_deactive->count(), $data_delete->count());

            return view('clients.leftclient_search', [
                // 'list'       =>  $list->get(),
                'deactiveCount'   =>  $data_deactive->count(),
                'deleteCount'     =>  $data_delete->count(),
                'deactive'   =>  $data_deactive->get(),
                'delete'     =>  $data_delete->get(),
            ]);
        }
    }
}
