@extends('layout.app')


@section('content')
    <div class="row">
        <div class="col-sm-4">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Name: {{ $reseller->name }}</p>
                    <p class="p-2" style="font-size:30px;font-weight:bold">Balance:
                        {{ $reseller->balance[0]['amount'] ?? 0 }}</p>
                    <hr>

                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount"
                            min="{{ intval($min_recharge_amount) }}" placeholder="Enter Amount">
                    </div>

                    @if (checkSettings('bkash-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="bkash">Bkash</button>
                    @endif
                    @if (checkSettings('upay-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="upay">Upay</button>
                    @endif
                    @if (checkSettings('nagad-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="nagad">Nagad</button>
                    @endif

                    @php
                        $buttons = collect(json_decode(siteinfo()->payment_button));
                        $ssl_image_btn = $buttons->where('type', 'ssl_img')->first();
                    @endphp
                    @if (checkSettings('ssl-reseller-recharge') == 'enable')
                        <button type="button" id="paySSL" class="btn ">
                            <img style="height:50px; border-radius:5px;padding:5px;"
                                src="@if (!empty($ssl_image_btn)) {{ asset('storage/company/' . $ssl_image_btn->value) }} @else visa.png @endif"
                                alt="">
                        </button>

                        <button style="display: none" class="hidden btn btn-primary btn-lg btn-block" id="sslczPayBtn"
                            token="if you have any token validation"
                            postdata="your javascript arrays or objects which requires in backend"
                            order="If you already have the transaction generated for current order"
                            endpoint="{{ route('resellerPayViaAjax') }}"> Pay Now
                        </button>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table table-borderd table-striped">
                                <thead class="bg-blue-50">
                                    <tr>

                                        <th>
                                            Date
                                        </th>

                                        <th class="text-right">
                                            Recharge Amount
                                        </th>

                                        <th class="text-right">
                                            After Recharge Balance
                                        </th>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <th class="text-right">Paid Amount</th>
                                        @endif

                                        <th>
                                            Remarks
                                        </th>
                                        <th>
                                            Recharge By
                                        </th>
                                        <th>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="
                                        bg-white divide-y divide-gray-200">
                                    @foreach ($rechargeList as $r)
                                        <tr>

                                            <td>
                                                {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                            </td>



                                            <td class="text-right">
                                                {{ $r->amount }}
                                            </td>


                                            <td class="text-right">
                                                {{ $r->after_recharge_balance }}
                                            </td>
                                            @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                                <td class="text-right">{{ $r->paid_amount }}</td>
                                            @endif

                                            <td>
                                                {{ $r->remarks }}
                                            </td>
                                            <td>
                                                {{ $r->user->name ?? '' }}
                                            </td>


                                        </tr>
                                    @endforeach

                                    <tr class="bg-info">
                                        <td class="text-right">Total Recharge: </td>
                                        <td class="text-right">{{ $rechargeList->sum('amount') }}</td>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <td class="text-right">Total Paid: </td>
                                            <td class="text-right">{{ $rechargeList->sum('paid_amount') }}</td>
                                        @endif
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {

            $('#upay').on('click', function() {
                payment('upay');
            });

            $('#bkash').on('click', function() {
                payment('bkash');
            });
            $('#nagad').on('click', function() {
                payment('nagad');
            });

            function setCookie(cname, cvalue, exdays) {
                const d = new Date();
                d.setTime(d.getTime() + (exdays * 60 * 1000));
                let expires = "expires=" + d.toUTCString();
                document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
            }

            function deleteCookie(cname) {
                document.cookie = cname + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
            }

            function payment(payment_method) {
                // $('#processing').show();
                let minAmount = {{ $min_recharge_amount }};
                let enteredAmount = parseFloat($('#amount').val());
                if (enteredAmount < minAmount) {
                    alert("Amount should not be less than " + minAmount);
                    return false;
                }

                $.ajax({
                    url: "{{ route('onlineManagerRechargeExecute') }}",
                    type: "POST",
                    data: {
                        amount: enteredAmount,
                        // amount: $('#amount').val(),
                        payment_method: payment_method,
                        reseller_id: {{ $reseller->id }},
                    },
                    success: function(data) {
                        $('#processing').hide();

                        if (payment_method == 'upay') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.message == "Merchant Payment Init Success") {

                                window.location.href = data.data.gateway_url;
                            }
                        } else if (payment_method == 'bkash') {
                            if (data.status == 'error') {


                                toastr.error(data.message);
                            } else if (data.statusMessage == "Successful") {

                                setCookie('online_reseller_recharge_reseller_id', data.reseller_id, 5);
                                setCookie('online_reseller_recharge_token_id', data.token, 5);
                                window.location.href = data.bkashURL;
                            }
                        } else if (payment_method == 'nagad') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.status == "success") {
                                window.location.href = data.message;
                            }
                        }


                    }
                });
            }
        });
    </script>

    @if (checkSettings('ssl-commerz-show') == 'enable')
        <script>
            var obj = {};
            $('#paySSL').on('click', function() {

                let minAmount = {{ $min_recharge_amount }};
                let enteredAmount = parseFloat($('#amount').val());

                obj.minAmount = {{ $min_recharge_amount }};
                obj.enteredAmount = parseFloat($('#amount').val());
                obj.reseller_id = {{ $reseller->id }};

                if (enteredAmount < minAmount) {
                    alert("Amount should not be less than " + minAmount);
                    return false;
                }

                if ($('#amount').val() != '') {
                    console.log(obj);
                    $('#sslczPayBtn').prop('postdata', obj);
                    $('#sslczPayBtn').click();
                } else {
                    toastr.error('Amount is required');
                }
            });
        </script>

        @if (checkSettings('ssl-commerz-live') == 'enable')
            <script>
                (function(window, document) {
                    var loader = function() {
                        var script = document.createElement("script"),
                            tag = document.getElementsByTagName("script")[0];
                        script.src = "https://seamless-epay.sslcommerz.com/embed.min.js?" + Math.random().toString(36)
                            .substring(7);
                        tag.parentNode.insertBefore(script, tag);
                    };
                    window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload",
                        loader);
                })(window, document);
            </script>
        @else
            <script>
                (function(window, document) {
                    var loader = function() {
                        var script = document.createElement("script"),
                            tag = document.getElementsByTagName("script")[0];
                        script.src = "https://sandbox.sslcommerz.com/embed.min.js?" + Math.random().toString(36).substring(
                            7);
                        tag.parentNode.insertBefore(script, tag);
                    };
                    window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload",
                        loader);
                })(window, document);
            </script>
        @endif
    @endif
@endpush
