@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('clientRegisterUpdate', $register->id) }}" method="POST">
                @csrf

                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">Name*</label>
                        <input type="text" name="name" value="{{ $register->name }}" class="form-control" required
                            placeholder="Name" autocomplete="off">
                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="email" class="block text-sm font-medium text-gray-700">Email*</label>
                        <input type="email" name="email" class="form-control" placeholder="email" required
                            value="{{ $register->email }}" autocomplete="off">
                        @error('email')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="phone" class="block text-sm font-medium text-gray-700">Contact*</label>
                        <input type="text" name="phone" class="form-control" placeholder="phone" required
                            value="{{ $register->phone }}" autocomplete="off">
                        @error('phone')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="address" class="block text-sm font-medium text-gray-700">Address*</label>
                        <input type="text" name="address" id="address" class="form-control" placeholder="Address"
                            required value="{{ $register->address }}" autocomplete="off">
                        @error('address')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="package" class="block text-sm font-medium text-gray-700">Package*</label>
                        <select name="package" class="select2 form-control" required>
                            <option value="">Select Package</option>
                            <option value="5MBPS" {{ $register->package == '5MBPS' ? 'selected' : '' }}>5 MBPS TK500 /
                                month
                            </option>
                            <option value="7MBPS" {{ $register->package == '7MBPS' ? 'selected' : '' }}>7 MBPS TK600 /
                                month</option>
                            <option value="8MBPS" {{ $register->package == '8MBPS' ? 'selected' : '' }}>8 MBPS TK700 /
                                month</option>
                            <option value="10MBPS" {{ $register->package == '10MBPS' ? 'selected' : '' }}>10 MBPS TK800 /
                                month</option>
                            <option value="15MBPS" {{ $register->package == '15MBPS' ? 'selected' : '' }}>15 MBPS TK1000 /
                                month</option>
                            <option value="20MBPS" {{ $register->package == '20MBPS' ? 'selected' : '' }}>20 MBPS TK1200 /
                                month</option>
                            <option value="25MBPS" {{ $register->package == '25MBPS' ? 'selected' : '' }}>25 MBPS TK1500 /
                                month</option>
                            <option value="30MBPS" {{ $register->package == '30MBPS' ? 'selected' : '' }}>30 MBPS TK2000 /
                                month</option>
                        </select>
                        @error('package')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="connectivity" class="block text-sm font-medium text-gray-700">Type*</label>
                        <select name="connectivity" class="select2 form-control" required>
                            <option value="">Select Type</option>
                            <option value="Home" {{ $register->connectivity == 'Home' ? 'selected' : '' }}>Home</option>
                            <option value="Corporate" {{ $register->connectivity == 'Corporate' ? 'selected' : '' }}>
                                Corporate</option>
                        </select>
                        @error('connectivity')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="message" class="block text-sm font-medium text-gray-700">Message</label>
                        <div class=" flex rounded-md shadow-sm">
                            <textarea name="message" class="form-control" placeholder="message">{{ $register->message }}</textarea>
                        </div>
                        @error('message')
                            <div class="alert alert-dangers">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="remarks" class="block text-sm font-medium text-gray-700">Remark</label>
                        <div class=" flex rounded-md shadow-sm">
                            <textarea name="remarks" class="form-control" placeholder="remarks">{{ $register->remarks }}</textarea>
                        </div>
                        @error('remarks')
                            <div class="alert alert-dangers">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="status" class="block text-sm font-medium text-gray-700">Status*</label>
                        <select name="status" class="select2 form-control" required>
                            <option value="">Select Status</option>
                            <option value="Pending" {{ $register->status == 'Pending' ? 'selected' : '' }}>Pending</option>
                            <option value="Approved" {{ $register->status == 'Approved' ? 'selected' : '' }}>Approved
                            </option>
                            <option value="Rejected" {{ $register->status == 'Rejected' ? 'selected' : '' }}>Rejected
                            </option>
                        </select>
                        @error('status')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <hr>
                <div class="col-sm-12">
                    <div class="form-group float-right">
                        <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i>
                            Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
