<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title></title>
    <style type="text/css">
        td {
            padding-top: 0 !important;
            padding-bottom: 0 !important;
            line-height: 1;
        }

        td p {
            line-height: initial !important;
            margin: 0;
        }

        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body onload="window.print()" onfocus="window.close()">
    <style>
        @media print {
            thead th {
                font-size: 15px !important;
                border: 1px solid #ddd;
            }

            #pop,
            button {
                visibility: hidden;
            }

            table,
            tr,
            thead th,
            td {
                font-size: 12px !important;
                padding: 2px !important;
                border: 1px solid #010a02;
                border-collapse: collapse;
            }
        }

        .container {
            width: 940px;
            margin: 0 auto;
            padding: 10px;
        }

        .table {

            border-collapse: collapse;
            width: 100%;
            border: 1px solid #4CAF50;
        }

        h2 {
            text-align: center;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 10px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }
    </style>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                        <div class="flex justify-between noprint">
                            <div class="p-2 mb-5">
                                <button type="button" onclick="window.print()">Print
                                    <i class="fa fa-print"></i>
                                </button>
                            </div>
                        </div>
                        <table class="table table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="">ID</th>
                                    <th>User name</th>
                                    @can('view-client-password')
                                        <th>Password</th>
                                    @endcan
                                    <th>Status</th>
                                    <th>Bill Cycle</th>
                                    <th>Package</th>
                                    @if ($price == 'yes')
                                        <th>Package price</th>
                                    @endif

                                    <th>Due</th>
                                    <th>POP</th>
                                    <th>Name</th>
                                    <th>Contact No</th>
                                    @if (checkSettings('seperate_address_column') == 'enable')
                                    <th>Area</th>
                                    <th>Block</th>
                                    <th>Road Name</th>
                                    <th>Road No</th>
                                    <th>Building Name</th>
                                    <th>Building No</th>
                                    <th>Flat</th>
                                    <th>Box</th>
                                    <th>OLT/PON</th>
                                    <th>Latitude</th>
                                    <th>Longitude</th>
                                    @else
                                        <th>Address</th>
                                    @endif

                                    @if (checkSettings('blank-column') == 'enable')
                                        <th style="width: 100px"></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach ($list as $r)
                                @php
                                    if(auth()->user()->id == 1){
                                        $password = $r->password;
                                    } else {
                                        $password = '********';
                                    }
                                @endphp
                                    <tr>
                                        <td> {{ $r->id }}
                                        </td>
                                        <td>
                                            <b>{{ $r->userid }}</b>
                                        </td>
                                        @can('view-client-password')
                                            <td>
                                                {{ $password }}
                                            </td>
                                        @endcan

                                        @if ($r->clients_status == 'expired')
                                            <td class="deactive bg-danger">
                                                Expired
                                            @elseif($r->clients_status == 'deactive')
                                            <td class="deactive bg-danger">
                                                Deactive
                                            @elseif($r->clients_status == 'disable')
                                            <td class="bg-warning">
                                                Disable
                                            @elseif($r->clients_status == 'active')
                                            <td class="bg-success">
                                                Active
                                            @elseif($r->client_approval == 'pending')
                                            <td>
                                                Pending
                                        @endif
                                        </td>
                                        <td>
                                            {{ $r->billing_cycle }}
                                        </td>
                                        <td>
                                            @can('show-sub-package')
                                                <span
                                                    class="badge badge-info"><b>{{ $r->subpack->name ?? '' }}</b></span><br>
                                            @endcan
                                            @can('show-mother-package')
                                                <span class="badge badge-info">
                                                    <b>{{ $r->packages->package_name ?? '' }}</b></span>
                                            @endcan
                                            @if (!empty($r->subpack->name))
                                            @else
                                            @endif
                                        </td>
                                        @if ($price == 'yes')
                                            <td>
                                                @can('show-sub-package-rate')
                                                    <span class="badge badge-info">{{ $r->subpack->rate ?? 0 }}</span>
                                                @endcan
                                                ,
                                                @can('show-motherpackage-rate')
                                                    <span
                                                        class="badge badge-info">{{ $r->packages->package_rate ?? 0 }}</span>
                                                @endcan
                                                ,
                                                @if (!empty($r->sub_package_rate))
                                                @else
                                                @endif


                                            </td>
                                        @endif

                                        <td>
                                            @if ($r->pop->bill_generate == 'yes')
                                                {{ $r->customerAccount->dueAmount ?? 0 }}
                                            @endif
                                        </td>
                                        <td>
                                            {{ $r->pop->popname }}
                                        </td>
                                        <td>
                                            {{ $r->clientsinfo->clients_name ?? '' }}
                                        </td>
                                        <td>
                                            <b>{{ $r->clientsinfo->contact_no ?? '' }}</b>
                                        </td>
                                        @if (checkSettings('seperate_address_column') == 'enable')
                                            <td>{{ $r->clientsinfo->area ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->block_sector ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->road_name ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->road_no ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->building_name ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->building_no ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->flat_no ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->box ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->olt_pon ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->client_latitude ?? '' }}</td>
                                            <td>{{ $r->clientsinfo->client_longitude ?? '' }}</td>
                                        @else
                                            <td style="max-width:250px;">
                                                <p style="font-size:12px;">
                                                    @if ($r->clientsinfo->flat_no)
                                                        Flat No: {{ $r->clientsinfo->flat_no ?? '' }},
                                                    @endif
                                                    @if ($r->clientsinfo->building_name)
                                                        Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->road_no)
                                                        Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->block_sector)
                                                        Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},
                                                    @endif
                                                    @if ($r->clientsinfo->area)
                                                        Area : {{ $r->clientsinfo->area ?? '' }}, <br>
                                                    @endif
                                                    @if ($r->clientsinfo->box)
                                                        Box : {{ $r->clientsinfo->box ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->client_latitude)
                                                        Latitude : {{ $r->clientsinfo->client_latitude ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->client_longitude)
                                                        Longitude : {{ $r->clientsinfo->client_longitude ?? '' }}
                                                    @endif
                                                </p>
                                            </td>
                                        @endif

                                        @if (checkSettings('blank-column') == 'enable')
                                            <td style="width: 100px"></td>
                                        @endif
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="15">
                                        <p class="text-center">
                                            Total Customer: {{ $list->count() }} |
                                            Total Active: {{ $list->where('clients_status', 'active')->count() }} |
                                            Total Expired: {{ $list->where('clients_status', 'expired')->count() }} |
                                            Total Disable: {{ $list->where('clients_status', 'disable')->count() }}|
                                            Total Deactive: {{ $list->where('clients_status', 'deactive')->count() }}
                                        </p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        window.onload = function() {
            window.print();
        }

        window.onfocus = function() {
            window.close();
        }
    </script>
</body>

</html>
