@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('experity.change') }}" method="post">
                @csrf

                <div class="form-group">
                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="pop_id">
                        Pop Name
                    </label>


                    <select name="pop_id" class="select2 form-control" required>
                        <option value="">Select Pop</option>
                        @foreach ($non_expired_pops as $nas)
                            <option class="p-5" value="{{ $nas->id }}">{{ $nas->popname }} </option>
                        @endforeach

                    </select>
                </div>
                <div class="form-group float-right">
                    <button class="btn btn-primary" type="submit">Exclude</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>
                {{-- time out maximum time 60 seconds fatal error --}}
                {{-- <div class="form-group float-right">
                    <button @click="search" class="btn btn-primary" type="submit" id="searchBtn">Exclude</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div> --}}

            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body table-responsive">

            <table class="table table-striped table-condensed">
                <thead class="bg-gray">
                    <tr>
                        <th>
                            ID
                        </th>
                        <th>
                            Pop name
                        </th>
                        <th>
                            Manager Name
                        </th>
                        <th>
                            NAS Server IP
                        </th>
                        <th>
                            POP Location
                        </th>
                        <th>
                            POP Status
                        </th>

                        <th>

                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($expired_pops as $r)
                        <tr>
                            <td>
                                {{ $r->id }}
                                <input type="hidden" id="client_id" value=" {{ $r->id }}">
                            </td>
                            <td>
                                {{ $r->popname ?? '' }}
                            </td>
                            <td>
                                {{ $r->reseller->name ?? '' }}
                            </td>

                            <td class="whitespace-nowrap">
                                {{ $r->nas->nasname }}
                            </td>
                            <td>
                                {{ $r->pop_location }}
                            </td>
                            <td>
                                {{ $r->status }}
                            </td>
                            <td class="px-6 text-left text-sm font-medium">
                                <form action="{{ route('experity.change') }}" method="POST" class="float-right">
                                    @csrf
                                    <input type="hidden" name="pop_id" value="{{ $r->id }}">
                                    <button type="submit" class="btn btn-info"><i class="fa fa-trash"></i> Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
