@extends('layout.app')

@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('device-type.store') }}" method="POST">
                @csrf

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" name="name" value="" required
                                placeholder="Enter Type Name">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group mt-3">
                            <button type="submit" class="btn btn-success mt-2">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('stock-return-store') }}" method="POST">
                @csrf

                <input type="hidden" name="clientId" id="" value="{{ $clientId }}">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th style="text-align: center">Device</th>
                            <th style="text-align: center">Status</th>
                            <th style="text-align: center">Mack Id</th>
                            <th style="text-align: center">Serial No</th>
                            <th style="text-align: center">Remark</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($deviceType as $item)
                            <tr>
                                <td class="col-md-3">
                                    <label for="">{{ $item->name }}</label>
                                    <input type="hidden" name="device_id[]" value="{{ $item->id }}"
                                        class="form-control" readonly>
                                </td>
                                <td class="col-md-3">
                                    <select name="status[]" id="" class="form-control select2">
                                        <option value="">Select One</option>
                                        <option value="Usable">Usable</option>
                                        <option value="NotUsable">Not Usable</option>
                                        <option value="PartiallyUsable">Partially Usable</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" name="mack[]" class="form-control" value=""
                                        placeholder="Mack Id">
                                </td>
                                <td>
                                    <input type="text" name="serial[]" class="form-control" value=""
                                        placeholder="Serial No">
                                </td>
                                <td>
                                    <input type="text" name="remark[]" class="form-control" value=""
                                        placeholder="Remark">
                                </td>
                            </tr>
                        @empty
                        @endforelse
                    </tbody>
                </table>

                <div class="col-md-12">
                    <div class="form-group mt-2 float-right">
                        <button type="submit" class="btn btn-success mt-2">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('ajax')
@endsection
