<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVoiceLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voice_logs', function (Blueprint $table) {
            $table->id();
            $table->string('contact')->nullable();
            $table->string('callerid')->nullable();
            $table->string('type')->nullable();
            $table->string('voice_file')->nullable();
            $table->string('call_status')->nullable();
            $table->text('message')->nullable();
            $table->integer('retry_count')->default(0);
            $table->integer('blast_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voice_logs');
    }
}
