<?php

namespace App\Classes\SMS;

use App\Jobs\ResellerSendSms;


class ExpireCustomerNotifySms
{


    public function sendOtherReseller($client, $gatway, $reseller_name, $reseller_cell, $message, $reseller_id)
    {


        $message = str_replace(
            [
                '{c_id}',
                '{c_code}',
                '{c_password}',
                '{c_name}',
                '{c_username}',
                '{c_password}',
                '{package_name}',
                '{package_price}',
                '{c_expire_date}',
                '{reseller_name}',
                '{reseller_mobile}',
                '{client_payment_amount}'
            ],
            [
                $client->id,
                $client->customer_code,
                $client->password,
                $client->clientsinfo->clients_name ?? '',
                $client->userid,
                $client->password,
                $client->packages->package_name,
                $client->packages->package_rate,
                // $client->expire_date,
                date('d-M-Y', strtotime($client->expire_date)),
                $reseller_name,
                $reseller_cell,
                ($client->client_payment_amount > 0) ? $client->client_payment_amount : $client->packages->client_payment_amount
            ],
            $message
        );

        $contact = $client->clientsinfo->contact_no;
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "Expire Customer",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
    }

    public function otherResellerCustomerSendSmsBeforeExpire($client, $gatway, $reseller_name, $reseller_cell, $message, $reseller_id)
    {

        $message = str_replace(
            [
                '{c_id}',
                '{c_code}',
                '{c_password}',
                '{c_username}',
                '{c_name}',
                '{c_expire_date}',
                '{package_price}',
                '{reseller_name}',
                '{reseller_mobile}',
                '{BTRC_speed}',
                '{BTRC_rate}',
                '{client_payment_amount}'
            ],
            [
                $client->id,
                $client->customer_code,
                $client->password,
                $client->userid,
                $client->clientsinfo->clients_name ?? '',
                $client->expire_date,
                $client->packages->package_rate,
                $reseller_name,
                $reseller_cell,
                $client->packages->package_bandwidth ?? 0,
                $client->packages->btrc_package_price ?? 0,
                ($client->client_payment_amount > 0) ? $client->client_payment_amount : $client->packages->client_payment_amount
            ],
            $message
        );

        $contact = $client->clientsinfo->contact_no;
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "Reminder",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
    }
}
