<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\UddoktapayController;
use App\Http\Controllers\Api\BillPaymentController;
use App\Http\Controllers\Api\PrepaidBillPaymentController;
use App\Http\Controllers\BkashWebhookController;
use App\Http\Controllers\BtrcReportController;
use App\Http\Controllers\ClientInformationController;
use App\Http\Controllers\ClientTransferController;
use App\Http\Controllers\DisconnectApiUserController;
use App\Http\Controllers\MikrotikController;
use App\Http\Controllers\NagadIpnController;
use App\Http\Controllers\PopController;
use App\Http\Controllers\VFCPBillPayController;
use App\Services\ApiBandwidthUsageService;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get("hello-test", function () {
    $onlineClient = new ApiBandwidthUsageService;
    dd($onlineClient->UpdateOnlineClientBandwidthUsage());
    return "hello world";
});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/customer/{userid}', [ClientController::class, 'showApi']);
Route::post('/getCustomerInfo', [ClientController::class, 'getCustomerInfo']);

Route::get('/total-customer', [ClientController::class, 'totalClient']);

// customer bill pay version 1

Route::post('bill-pay/v1/check-bill', [BillPaymentController::class, 'checkBill']);
Route::get('bill-pay/v1/check-bill', function () {
    abort(404, 'Not Found');
});

Route::post('bill-pay/v1/payment', [BillPaymentController::class, 'payment']);
Route::post('bill-pay/v1/search', [BillPaymentController::class, 'search']);
Route::delete('bill-pay/v1/delete', [BillPaymentController::class, 'delete']);

// pay-bill(prepaid)
Route::post('pay-bill/v2/bill-check', [PrepaidBillPaymentController::class, 'checkPrepaidBill']);
Route::get('pay-bill/v2/bill-check', function () {
    abort(404, 'Sorry, Not Found!');
});

Route::post('pay-bill/v2/pre-payment', [PrepaidBillPaymentController::class, 'prePayment']);
Route::post('pay-bill/v2/bill-search', [PrepaidBillPaymentController::class, 'billSearch']);

// uddokta pay route

Route::post('webhook-uddokta-pay', [UddoktapayController::class, 'webhook'])->name('uddoktapay.webhook');



Route::get('/mikrotik-information/{id}/{email}',[MikrotikController::class,'getMikrotik']);
Route::post('pgw-nagad/v1/ipn', [NagadIpnController::class, 'save']);

Route::post('bkashWebhook', [BkashWebhookController::class, 'handleWebhook'])->name('bkash.webhook');

Route::post('pay-bill/vfcp/v1/grantToken',[VFCPBillPayController::class,'grantToken'])->middleware('api');
Route::post('pay-bill/vfcp/v1/getTotalBillCountByBillingCycle',[VFCPBillPayController::class,'getTotalBillCountByBillingCycle'])->middleware('api');
Route::post('pay-bill/vfcp/v1/getBillDocumentByBillingCycle',[VFCPBillPayController::class,'getBillDocumentByBillingCycle'])->middleware('api');
Route::post('pay-bill/vfcp/v1/pushPaymentTransaction',[VFCPBillPayController::class,'pushPaymentTransaction'])->middleware('api');


// BTRC Report API
Route::get('btrc/active-user',[BtrcReportController::class,'activeUser']);
Route::get('btrc/coverage-thana-level',[BtrcReportController::class,'thanaLevel']);
Route::get('btrc/monthly-ticket-generation',[BtrcReportController::class,'monthlyTicketGenerated']);
Route::get('btrc/average-time-to-resolve-ticket',[BtrcReportController::class,'averageTimeToResolveTicket']);


// Disconnect Users
Route::get('disconnectUsers',[DisconnectApiUserController::class,'disconnectUsers']);

// api all to transfer all client info
Route::post('api-all/v1/transfer-client-info',[ClientTransferController::class,'transferClientInfo']);
Route::post('api-all/v1/sync-client-info',[ClientTransferController::class,'syncClientInfo']);


Route::post('clientInformation', [ClientInformationController::class, 'getClientInformation']);

Route::get('poplist', [PopController::class, 'getPopList']);

Route::post('test', function (Request $request) {
    $data = $request->all();
    return response()->json([
        'status' => 'success',
        'message' => 'Data received successfully',
        'data' => $data
    ]);
})->name('test.api'); // Example route for testing purposes

Route::post('client-ticket-info', [ClientInformationController::class, 'clientTicketInfo'])->name('clientTicketInfo');

Route::get('get-client-info/mikrotik', [ClientInformationController::class, 'mikrotikInfo'])->name('getClientInfoSession');
