<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VoiceBroadcast extends Model
{
    use HasFactory;

    public const STATUS_ENABLED = 'enabled';
    public const STATUS_DISABLED = 'disabled';

    protected $guarded = ['id'];

    /**
     * Scope only voices that can be used for sending.
     */
    public function scopeEnabled($query)
    {
        return $query->where('status', self::STATUS_ENABLED);
    }

    /**
     * Resolve absolute storage path for playback.
     */
    public function absolutePath(): string
    {
        $base = $this->disk === 'public' ? 'app/public/' : 'app/' . $this->disk . '/';

        return storage_path($base . ltrim($this->file_path, '/'));
    }

    /**
     * Determine if the voice asset can be used.
     */
    public function isEnabled(): bool
    {
        return $this->status === self::STATUS_ENABLED;
    }
}

