<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\CustomerAccount;
use App\Models\Pop;
use App\Models\Reseller;
use Carbon\Carbon;
use Illuminate\Http\Request;

class BillDateExtendedController extends Controller
{
    public function billExtendedCustomers()
    {
        $resellers = Reseller::list()->where('reseller_type', 'own');
        $data=[
            'resellers' => $resellers,
            'confday' => config('app.billing_cycle'),
        ];

        return view('clients.bulkExpaireExtended.list', $data);
    }

    public function getBillExtendsCustomers(Request $request)
    {

        if($request->reseller == "all"){
            $resellers = Reseller::list()->where('reseller_type', 'own');
        }else{
            $resellers = Reseller::list()->where('id', $request->reseller);
        }
        if($request->pop == "all"){
            $popes = Pop::whereIn('reseller_id', $resellers->pluck('id'))->get();
            $clients = Client::with('packages','pop','clientsinfo','customerAccount','subpack')->whereIn('pop_id', $popes->pluck('id'));
        }else{
            $popes = Pop::where('id',$request->pop)->get();
            $clients = Client::with('packages','pop','clientsinfo','customerAccount','subpack')->whereIn('pop_id', $popes->pluck('id'));
        }


        if($request->billing_cycle != "all"){
            $clients = $clients->where('billing_cycle', $request->billing_cycle)->where('payment_dadeline','!=',0)->get();
        }else{
            $clients = $clients->where('payment_dadeline','!=',0)->get();
        }


        // $clients = $clients->whereIn('id', $due_customer_list->pluck('client_id'))->get();

        $new_clients = [];
        if($request->area != "all"){
            foreach($clients as $client){
                if($client->clientsinfo->area == $request->area){
                    $new_clients[] = $client;
                }
            }
        }else{
            $new_clients = $clients;
        }
        $final_clients = [];
        $mother_packge_permissin = false;
        if (auth()->user()->hasPermissionTo('show-mother-package') && auth()->user()->hasPermissionTo('show-sub-package')) {
            foreach($new_clients as $key => $client){
                $final_clients[$client->id]['id'] = $client->id;
                $final_clients[$client->id]['user_id'] = $client->userid;
                $final_clients[$client->id]['password'] = $client->password;
                $final_clients[$client->id]['status'] = $client->clients_status;
                $final_clients[$client->id]['expire_date'] = Carbon::parse($client->expire_date)->format('d-m-Y');
                $final_clients[$client->id]['billing_cycle'] = $client->billing_cycle;
                $final_clients[$client->id]['sub_package'] =  $client->subpack->name ?? '';
                $final_clients[$client->id]['mother_package'] = $client->packages->package_name ?? '';
                $final_clients[$client->id]['name'] = $client->clientsinfo->clients_name ?? '';
                $final_clients[$client->id]['contact_no'] = $client->clientsinfo->contact_no ?? '';
                $final_clients[$client->id]['pop_name'] = $client->pop->popname ?? '';
                $final_clients[$client->id]['flat_no'] = $client->clientsinfo->flat_no ?? '';
                $final_clients[$client->id]['building_name'] = $client->clientsinfo->building_name ?? '';
                $final_clients[$client->id]['road_no'] = $client->clientsinfo->road_no ?? '';
                $final_clients[$client->id]['block_sector'] = $client->clientsinfo->block_sector ?? '';
                $final_clients[$client->id]['area'] = $client->clientsinfo->area ?? '';
                $final_clients[$client->id]['box'] = $client->clientsinfo->box ?? '';
                $final_clients[$client->id]['client_latitude'] = $client->clientsinfo->client_latitude  ?? '';
                $final_clients[$client->id]['client_longitude'] = $client->clientsinfo->client_longitude  ?? '';
                $final_clients[$client->id]['created_at'] = Carbon::parse($client->created_at)->format('d-m-Y H:i:sa')  ?? '';
                $final_clients[$client->id]['joinDate'] = Carbon::parse($client->clientsinfo->joinDate)->format('d-m-Y ') ?? '';
                $final_clients[$client->id]['bill_generate'] = $client->pop->bill_generate;
                $final_clients[$client->id]['deleted_at'] = $client->deleted_at;
                $final_clients[$client->id]['due_amount'] = $client->customerAccount->dueAmount ?? 0;
                $final_clients[$client->id]['payment_dadeline'] = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-m-Y') ?? 0;
            }
            $data=[
                'clients' => $final_clients,
                'areas' => $request->area,
            ];

            return $data;
        }else if (auth()->user()->hasPermissionTo('show-mother-package')) {
            foreach($new_clients as $key => $client){
                $final_clients[$client->id]['id'] = $client->id;
                $final_clients[$client->id]['user_id'] = $client->userid;
                $final_clients[$client->id]['password'] = $client->password;
                $final_clients[$client->id]['status'] = $client->clients_status;
                $final_clients[$client->id]['expire_date'] = Carbon::parse($client->expire_date)->format('d-m-Y');
                $final_clients[$client->id]['billing_cycle'] = $client->billing_cycle;
                $final_clients[$client->id]['sub_package'] =  '';
                $final_clients[$client->id]['mother_package'] = $client->packages->package_name ?? '';
                $final_clients[$client->id]['name'] = $client->clientsinfo->clients_name ?? '';
                $final_clients[$client->id]['contact_no'] = $client->clientsinfo->contact_no ?? '';
                $final_clients[$client->id]['pop_name'] = $client->pop->popname ?? '';
                $final_clients[$client->id]['flat_no'] = $client->clientsinfo->flat_no ?? '';
                $final_clients[$client->id]['building_name'] = $client->clientsinfo->building_name ?? '';
                $final_clients[$client->id]['road_no'] = $client->clientsinfo->road_no ?? '';
                $final_clients[$client->id]['block_sector'] = $client->clientsinfo->block_sector ?? '';
                $final_clients[$client->id]['area'] = $client->clientsinfo->area ?? '';
                $final_clients[$client->id]['box'] = $client->clientsinfo->box ?? '';
                $final_clients[$client->id]['client_latitude'] = $client->clientsinfo->client_latitude  ?? '';
                $final_clients[$client->id]['client_longitude'] = $client->clientsinfo->client_longitude  ?? '';
                $final_clients[$client->id]['created_at'] = Carbon::parse($client->created_at)->format('d-m-Y H:i:sa')  ?? '';
                $final_clients[$client->id]['joinDate'] = Carbon::parse($client->clientsinfo->joinDate)->format('d-m-Y ') ?? '';
                $final_clients[$client->id]['bill_generate'] = $client->pop->bill_generate;
                $final_clients[$client->id]['deleted_at'] = $client->deleted_at;
                $final_clients[$client->id]['due_amount'] = $client->customerAccount->dueAmount ?? 0;
                $final_clients[$client->id]['payment_dadeline'] = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-m-Y') ?? 0;

            }
            $data=[
                'clients' => $final_clients,
                'areas' => $request->area,
            ];

            return $data;
        }else if(auth()->user()->hasPermissionTo('show-sub-package')){
            foreach($new_clients as $key => $client){
                $final_clients[$client->id]['id'] = $client->id;
                $final_clients[$client->id]['user_id'] = $client->userid;
                $final_clients[$client->id]['password'] = $client->password;
                $final_clients[$client->id]['status'] = $client->clients_status;
                $final_clients[$client->id]['expire_date'] = Carbon::parse($client->expire_date)->format('d-m-Y');
                $final_clients[$client->id]['billing_cycle'] = $client->billing_cycle;
                $final_clients[$client->id]['sub_package'] = $client->subpack->name ?? '';
                $final_clients[$client->id]['mother_package'] = '';
                $final_clients[$client->id]['name'] = $client->clientsinfo->clients_name ?? '';
                $final_clients[$client->id]['contact_no'] = $client->clientsinfo->contact_no ?? '';
                $final_clients[$client->id]['pop_name'] = $client->pop->popname ?? '';
                $final_clients[$client->id]['flat_no'] = $client->clientsinfo->flat_no ?? '';
                $final_clients[$client->id]['building_name'] = $client->clientsinfo->building_name ?? '';
                $final_clients[$client->id]['road_no'] = $client->clientsinfo->road_no ?? '';
                $final_clients[$client->id]['block_sector'] = $client->clientsinfo->block_sector ?? '';
                $final_clients[$client->id]['area'] = $client->clientsinfo->area ?? '';
                $final_clients[$client->id]['box'] = $client->clientsinfo->box ?? '';
                $final_clients[$client->id]['client_latitude'] = $client->clientsinfo->client_latitude  ?? '';
                $final_clients[$client->id]['client_longitude'] = $client->clientsinfo->client_longitude  ?? '';
                $final_clients[$client->id]['created_at'] = Carbon::parse($client->created_at)->format('d-m-Y H:i:sa')  ?? '';
                $final_clients[$client->id]['joinDate'] = Carbon::parse($client->clientsinfo->joinDate)->format('d-m-Y ') ?? '';
                $final_clients[$client->id]['bill_generate'] = $client->pop->bill_generate;
                $final_clients[$client->id]['deleted_at'] = $client->deleted_at;
                $final_clients[$client->id]['due_amount'] = $client->customerAccount->dueAmount ?? 0;
                $final_clients[$client->id]['payment_dadeline'] = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-m-Y') ?? 0;

            }
            $data=[
                'clients' => $final_clients,
                'areas' => $request->area,
            ];

            return $data;
        }else{
            foreach($new_clients as $key => $client){
                $final_clients[$client->id]['id'] = $client->id;
                $final_clients[$client->id]['user_id'] = $client->userid;
                $final_clients[$client->id]['password'] = $client->password;
                $final_clients[$client->id]['status'] = $client->clients_status;
                $final_clients[$client->id]['expire_date'] = Carbon::parse($client->expire_date)->format('d-m-Y');
                $final_clients[$client->id]['billing_cycle'] = $client->billing_cycle;
                $final_clients[$client->id]['sub_package'] = "";
                $final_clients[$client->id]['mother_package'] = '';
                $final_clients[$client->id]['name'] = $client->clientsinfo->clients_name ?? '';
                $final_clients[$client->id]['contact_no'] = $client->clientsinfo->contact_no ?? '';
                $final_clients[$client->id]['pop_name'] = $client->pop->popname ?? '';
                $final_clients[$client->id]['flat_no'] = $client->clientsinfo->flat_no ?? '';
                $final_clients[$client->id]['building_name'] = $client->clientsinfo->building_name ?? '';
                $final_clients[$client->id]['road_no'] = $client->clientsinfo->road_no ?? '';
                $final_clients[$client->id]['block_sector'] = $client->clientsinfo->block_sector ?? '';
                $final_clients[$client->id]['area'] = $client->clientsinfo->area ?? '';
                $final_clients[$client->id]['box'] = $client->clientsinfo->box ?? '';
                $final_clients[$client->id]['client_latitude'] = $client->clientsinfo->client_latitude  ?? '';
                $final_clients[$client->id]['client_longitude'] = $client->clientsinfo->client_longitude  ?? '';
                $final_clients[$client->id]['created_at'] = Carbon::parse($client->created_at)->format('d-m-Y H:i:sa')  ?? '';
                $final_clients[$client->id]['joinDate'] = Carbon::parse($client->clientsinfo->joinDate)->format('d-m-Y ') ?? '';
                $final_clients[$client->id]['bill_generate'] = $client->pop->bill_generate;
                $final_clients[$client->id]['deleted_at'] = $client->deleted_at;
                $final_clients[$client->id]['due_amount'] = $client->customerAccount->dueAmount ?? 0;
                $final_clients[$client->id]['payment_dadeline'] = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-m-Y') ?? 0;

            }

            $data=[
                'clients' => $final_clients,
                'areas' => $request->area,
            ];

            return $data;
        }
    }
}
