<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Services\ExpireDateRoundService;
use App\Classes\MikrotikService\SyncWithMk;
use App\Http\Controllers\FixCommonIssueController;
use App\Http\Controllers\OnlinePaymentGetwayTokenController;

class CommonCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:common';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command is for common fix';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        (new FixCommonIssueController)->fixedThanIssue();
        (new FixCommonIssueController)->fixedDuplicateMoneyReceiptNumber();
        (new FixCommonIssueController)->addNewSmsToResellerSmsSetting();
        (new FixCommonIssueController)->addAllManagerAndPopAccount();
        (new FixCommonIssueController)->updateWelcomeAndBillpaySms();
        (new FixCommonIssueController)->addNewRoleForResellerBilling();





    }
}
