import { Form } from "react-bootstrap";
import axiosInstance from "../../../../../../util/axiosInstance";
import { toast } from "react-hot-toast";
import _ from "lodash";
import { getColor } from "../../../../../../util/colorModule";

function SelectComponent({
    componentOption,
    onComponentChangeHandler,
    cluster,
}) {
    switch (componentOption) {
        case "device":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Device</Form.Label>
                    <Form.Select onChange={onComponentChangeHandler}>
                        <option>select device</option>
                        {cluster.devices.map((device) => (
                            <option value={device.id} key={device.id}>
                                {device.id}: {device.name} -{" "}
                                {device.manufactures} - {device.model}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );

        case "splitter":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Splitter</Form.Label>
                    <Form.Select onChange={onComponentChangeHandler}>
                        <option>select Splitter</option>
                        {cluster.splitters.map((splitter) => (
                            <option value={splitter.id} key={splitter.id}>
                                {splitter.id}: {splitter.name} - 1:
                                {splitter.split_ratio} - used:{splitter.used}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );

        case "onu":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Onu</Form.Label>
                    <Form.Select onChange={onComponentChangeHandler}>
                        <option>Select Onu</option>
                        {cluster.onus.map((onu) => (
                            <option value={onu.id} key={onu.id}>
                                {onu.id}: {onu.name} - {onu.manufactures} -{" "}
                                {onu.model}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );
        case "client":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Client</Form.Label>
                    <Form.Select onChange={onComponentChangeHandler}>
                        <option>Select Client</option>
                        {cluster.clients.map((client) => (
                            <option
                                value={client.client.id}
                                key={client.client.id}
                            >
                                {client.client.id}: {client.client.userid} -{" "}
                                {client.clients_name} -{" "}
                                {client.client.clients_status}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );
        default:
            return null;
    }
}

function SelectInput({ component, onPortChangeHandler }) {
    switch (component?.type) {
        case "device":
            return (
                <Form.Group className="mt-2" onChange={onPortChangeHandler}>
                    <Form.Label>Select Port</Form.Label>
                    <Form.Select>
                        <option>select port</option>
                        {component?.ports?.map((port) => (
                            <option value={port.id} key={port.id}>
                                {port.port_number}: {port.label} -{" "}
                                {_.toUpper(port.port_type)}
                                {port.port_stream === "incoming"
                                    ? "⬇️"
                                    : "⬆️"}{" "}
                                {port.connected_component_id || port.fiber_id
                                    ? "- Used"
                                    : "- Available"}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );
        case "splitter":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Core</Form.Label>
                    <Form.Select onChange={onPortChangeHandler}>
                        <option>Select Output Core</option>
                        {component?.splitter_out?.map((output_core) => (
                            <option value={output_core.id} key={output_core.id}>
                                {output_core.out_number}:{" "}
                                {getColor(
                                    ((output_core.out_number - 1) % 12) + 1
                                )}{" "}
                                {output_core.connected_component_id ||
                                output_core.fiber_id
                                    ? "- Used"
                                    : "- Available"}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );

        case "onu":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Onu Port</Form.Label>
                    <Form.Select onChange={onPortChangeHandler}>
                        <option value="">Select Onu Interface</option>
                        <option value="ethernet">
                            Ethernet{" "}
                            {component.lan_connected_component_id
                                ? " - Used"
                                : " - Available"}
                        </option>
                        <option value="optical">
                            Optical{" "}
                            {component.optical_connected_component_id
                                ? " - Used"
                                : " - Available"}
                        </option>
                    </Form.Select>
                </Form.Group>
            );
        default:
            return null;
    }
}

const DeviceB = ({
    cluster,
    setPort,
    componentOption,
    setComponentOption,
    component,
    setComponent,
}) => {
    const onComponentChangeHandler = async (e) => {
        if (isNaN(e.target.value)) {
            setComponent(null);
            return;
        }
        setComponent(null);
        try {
            if (componentOption === "device") {
                const { data } = await axiosInstance.get(
                    `/devices/${e.target.value}`
                );
                setComponent(data);
            } else if (componentOption === "splitter") {
                const { data } = await axiosInstance.get(
                    `/splitters/${e.target.value}`
                );
                setComponent(data);
            } else if (componentOption === "onu") {
                const { data } = await axiosInstance.get(
                    `/onus/${e.target.value}`
                );
                setComponent(data);
            } else if (componentOption === "client") {
                setComponent({ type: "client", id: parseInt(e.target.value) });
            }
        } catch (error) {
            toast.error(error.message);
        }
    };

    const onPortChangeHandler = (event) => {
        if (isNaN(event.target.value) && componentOption !== "onu") {
            setPort(null);
            return;
        } else if (componentOption === "onu") {
            if (event.target.value !== "") {
                setPort(event.target.value);
            } else setPort(null);
            return;
        } else {
            setPort(parseInt(event.target.value));
        }
    };

    return (
        <>
            {" "}
            <h6>Component B</h6>
            <div className="w-75 mt-3 m-auto">
                <Form.Group className="mt-2">
                    <Form.Label>Select Component Type</Form.Label>
                    <Form.Select
                        onChange={(e) => {
                            setComponentOption(e.target.value);
                            setPort(null);
                            setComponent(null);
                        }}
                    >
                        <option>Select Component</option>
                        <option value="device">Device</option>
                        <option value="splitter">Splitter</option>
                        <option value="onu">ONU</option>
                        <option value="client">Client</option>
                    </Form.Select>
                </Form.Group>
                <SelectComponent
                    onComponentChangeHandler={onComponentChangeHandler}
                    cluster={cluster}
                    componentOption={componentOption}
                />
                <SelectInput
                    onPortChangeHandler={onPortChangeHandler}
                    component={component}
                />
            </div>
        </>
    );
};

export default DeviceB;
