@extends('layout.app')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-primary">
                        <div class="card-header bg-light">
                            <h3 class="card-title" style="color:#115548;">Add Line Shift</h3>
                            <div class="card-tools">
                                <a href="{{ route('line-shift.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center pt-3 mb-2">
                            <input type="" name="search" id="search" class="form-control col-md-4 "
                                placeholder="Search by customer user name" autocomplete="off">
                        </div>
                        <div class="d-flex justify-content-center mb-2" id="productList">
                            <ul id="customer_list" class="sub-menu">
                            </ul>
                        </div>

                        <form method="POST" action="{{ route('line-shift.store') }}" enctype="multipart/form-data">
                            @csrf

                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-md-3">
                                        <label for="shortname">
                                            CID
                                        </label>
                                        <input type="" name="client_userid" id="client_userid" class="form-control"
                                            placeholder="" autocomplete="off" readonly>
                                        @error('client_userid')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="shortname">
                                            Username
                                        </label>
                                        <input id="username" class="form-control" placeholder="" autocomplete="off"
                                            readonly>

                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="shortname">
                                            Client Name
                                        </label>
                                        <input type="text" id="clientName" value="" readonly class="form-control"
                                            placeholder="Client Name" autocomplete="off" >
                                        @error('clientName')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>

                                    <input type="hidden" id="pop_id" name="pop_id" value="" readonly
                                        class="form-control" placeholder="pop" autocomplete="off" >

                                    <div class="form-group col-md-3">
                                        <label for="shortname">
                                            Contact No*
                                        </label>
                                        <input type="text" name="contact" id="contact" value="" minlength="11"
                                            maxlength="11" class="form-control" placeholder="Contact No" autocomplete="off"
                                            >
                                        @error('contact')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="old_address">
                                            Old Address*
                                        </label>
                                        <textarea id="old_address" name="old_address" class="form-control"  readonly placeholder="Old address"></textarea>
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="shifting_date">
                                            Shifting Date*
                                        </label>
                                        <input type="date" name="shifting_date" class="form-control"
                                            placeholder="Enter Date" >
                                        @error('shifting_date')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="flat_no" class="block pt-2">
                                            Flat/Level No
                                        </label>

                                        <input type="text" name="flat_no" id="flat_no" value="{{ old('flat_no') }}"
                                            class="form-control " placeholder="Flat No">
                                        @error('flat_no')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror

                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="password" class="block pt-2">
                                            Building No
                                        </label>

                                        <input type="text" name="building_no" id="building_no"
                                            value="{{ old('building_no') }}" class="form-control "
                                            placeholder="Building No">
                                        @error('building_no')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror

                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="building_name" class="block pt-2">
                                            Building Name
                                        </label>

                                        <input type="text" name="building_name" id="building_name"
                                            value="{{ old('building_name') }}" class="form-control "
                                            placeholder="Building Name">
                                        @error('building_name')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror

                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="road_no" class="block pt-2">
                                            Road No
                                        </label>

                                        <input type="text" name="road_no" id="road_no"
                                            value="{{ old('road_no') }}" class="form-control " placeholder="Road No">
                                        @error('road_no')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror

                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="road_name" class="block pt-2">
                                            Road Name
                                        </label>

                                        <input type="text" name="road_name" id="road_name"
                                            value="{{ old('road_name') }}" class="form-control "
                                            placeholder="Road Name">
                                        @error('road_name')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror

                                    </div>

                                    <div class="form-group col-sm-3">
                                        <label for="block_sector" class="block pt-2">
                                            Block/Sector
                                        </label>
                                        <input type="text" name="block_sector" id="block_sector"
                                            value="{{ old('block_sector') }}" class="form-control "
                                            placeholder="Block/Sector">
                                        @error('block_sector')
                                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-sm-3">
                                        <label for="area" class="block pt-2">
                                            Area*
                                        </label>
                                        <input type="text" name="area" id="area" value="{{ old('area') }}"
                                            class="form-control" placeholder="Area">
                                    </div>

                                    @error('area')
                                        <div class="alert alert-danger mt-1">{{ $message }}</div>
                                    @enderror
                                    <div class="col-sm-3">
                                        <label for="area" class="block pt-2">
                                            Box
                                        </label>
                                        <input type="text" name="box" id="box" value="{{ old('box') }}"
                                            class="form-control " placeholder="box">
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="latitude" class="block pt-2">
                                            Latitude
                                        </label>
                                        <input type="text" name="client_latitude" id="client_latitude"
                                            value="{{ old('client_latitude') }}" class="form-control "
                                            placeholder="latitude">
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="longitude" class="block pt-2">
                                            Longitude
                                        </label>
                                        <input type="text" name="client_longitude" id="client_longitude"
                                            value="{{ old('client_longitude') }}" class="form-control "
                                            placeholder="longitude">
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="status" class="block pt-2">
                                            Status*
                                        </label>
                                        <select name="status" class="form-control" >
                                            <option value="">Select One</option>
                                            <option value="Done">Done</option>
                                            <option value="Done and Cable Remove">Done and Cable Remove</option>
                                            <option value="Pending">Pending</option>
                                            <option value="Not Possible">Not Possible</option>
                                        </select>
                                    </div>

                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary float-right">
                                        Save
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-2"></div>
            </div>
        </div>
    </section>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {

            function addCustomerInlist(id, customer_name, customer_mobile, userid, pop_id, flat_no, building_no,
                building_name, road_no, road_name, block_sector, area, box, client_latitude, client_longitude) {
                if (customer_name == null) {
                    customer_name = '';
                }
                if (customer_mobile == null) {
                    customer_mobile = '';
                }
                $("#customer_list").append(
                    '<li class="list-group-item list-group-item-dark customer_li" style="background-color:skyblue;">' +
                    '<div class="row">' +
                    '<p><strong> ' + customer_name + '-(' + customer_mobile + ')</strong><br>' +
                    '<b >UserId: </b>' + userid + '<br>' +
                    '</p>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_id" value="' + id +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_user_name" value="' + userid +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_name" value="' + customer_name +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_mobile" value="' +
                    customer_mobile + '" name="reference_no" placeholder="Enter Name" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="flat_no" value="' +
                    flat_no + '" name="flat_no" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="building_no" value="' +
                    building_no + '" name="building_no" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="building_name" value="' +
                    building_name + '" name="building_name" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="road_no" value="' +
                    road_no + '" name="road_no" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="road_name" value="' +
                    road_name + '" name="road_name" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="block_sector" value="' +
                    block_sector + '" name="block_sector" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="area" value="' +
                    area + '" name="area" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="box" value="' +
                    box + '" name="box" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="client_latitude" value="' +
                    client_latitude + '" name="client_latitude" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="client_longitude" value="' +
                    client_longitude + '" name="client_longitude" placeholder="flat no" ></div>' +

                    '<div class="col-md-6"><input type="hidden" class="pop_id" value="' +
                    pop_id + '" name="pop_id" placeholder="flat no" ></div>' +

                    '</div>' +
                    '</li>'
                );
            }


            $("#search").keyup(function() {
                var search = $(this).val();
                if (search.length >= 2) {
                    // console.log(search.length);
                    $.ajax({
                        url: '{{ route('getLineShiftcustomer') }}',
                        method: "GET",
                        data: {
                            search: search
                        },
                        success: function(data) {
                            $("#customer_list").empty();
                            data.forEach(element => {
                                addCustomerInlist(element.id,
                                    element.clientsinfo.clients_name,
                                    element.clientsinfo.contact_no,
                                    element.userid, element.pop_id,
                                    element.clientsinfo.flat_no,
                                    element.clientsinfo.building_no,
                                    element.clientsinfo.building_name,
                                    element.clientsinfo.road_no,
                                    element.clientsinfo.road_name,
                                    element.clientsinfo.block_sector,
                                    element.clientsinfo.area,
                                    element.clientsinfo.box,
                                    element.clientsinfo.client_latitude,
                                    element.clientsinfo.client_longitude
                                );
                            });
                        }
                    });
                } else {
                    $("#customer_list").empty();
                }

            });

            $(document).on('click', '.customer_li', function() {
                var customer_cid = $(this).find('.customer_id').val();
                var customer_user_name = $(this).find('.customer_user_name').val();

                var pop_id = $(this).find('.pop_id').val();

                var customer_name = $(this).find('.customer_name').val();
                var customer_mobile = $(this).find('.customer_mobile').val();

                var flat_no = $(this).find('.flat_no').val();
                var building_no = $(this).find('.building_no').val();
                var building_name = $(this).find('.building_name').val();
                var road_no = $(this).find('.road_no').val();
                var road_name = $(this).find('.road_name').val();
                var block_sector = $(this).find('.block_sector').val();
                var area = $(this).find('.area').val();
                var box = $(this).find('.box').val();
                var client_latitude = $(this).find('.client_latitude').val();
                var client_longitude = $(this).find('.client_longitude').val();

                $("#client_userid").val(customer_cid);
                $("#username").val(customer_user_name);
                $("#clientName").val(customer_name);
                $("#contact").val(customer_mobile);
                $("#pop_id").val(pop_id);

                $("#old_address").val('Flat No- ' + flat_no +
                    ', Building No- ' + building_no +
                    ', building name- ' + building_name +
                    ', road no- ' + road_no +
                    ', road name- ' + road_name +
                    ', block- ' + block_sector +
                    ', area- ' + area +
                    ', box- ' + box +
                    ', lat- ' + client_latitude +
                    ', long- ' + client_longitude
                );

                $("#customer_list").empty();
            });

        });
    </script>
@endsection
