@extends('layout.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12 text-right">
            <a href="{{ route('new-line-request.create') }}" class="btn btn-info btn-sm">
                <i class="fas fa-plus"></i> Create New Request
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Search New Line Requests</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('new-line-request.index') }}" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>POP</label>
                            <select name="pop_id" class="form-control select2">
                                <option value="">Select POP</option>
                                @foreach($pops as $pop)
                                    <option value="{{ $pop->id }}" {{ request('pop_id') == $pop->id ? 'selected' : '' }}>
                                        {{ $pop->popname }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Status</label>
                            <select name="status" class="form-control select2">
                                <option value="">Select Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                <option value="done" {{ request('status') == 'done' ? 'selected' : '' }}>Done</option>
                                {{-- <option value="pending" selected>Pending</option>
                                <option value="approved">Approved</option>
                                <option value="cancelled">Cancelled</option>
                                <option value="done">Done</option> --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <a href="{{ route('new-line-request.index') }}" class="btn btn-secondary btn-sm float-right ml-1">Reset</a>
                            <button type="submit" class="btn btn-primary btn-sm float-right">Search</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @include('clients.newclient.result')

</div>
@endsection

@section('ajax')
<script>
    $(function () {
        if ($.fn.DataTable && $('#dataTable').length) {
            $('#dataTable').DataTable({
                destroy: true,
                pageLength: 100
            });
        }

        $(document).on('click', '.open-status-modal', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var status = $(this).data('status');
            var url = '{{ route("new-line-request.status", "ID_PLACEHOLDER") }}'.replace('ID_PLACEHOLDER', id);
            $('#statusForm').attr('action', url);
            $('#statusSelect').val(status);
            $('#statusModal').modal('show');
        });

        $(document).on('click', '.open-remark-modal', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var url = '{{ route("new-line-request.remark", "ID_PLACEHOLDER") }}'.replace('ID_PLACEHOLDER', id);
            $('#remarkForm').attr('action', url);
            $('#remarkModal').modal('show');
        });
    });
</script>
@endsection
