<div class="d-flex justify-content-end mb-3">
    <button class="btn btn-success mr-2" id="downloadExcel">Download Excel</button>
    <button class="btn btn-danger" id="downloadPDF">Download PDF</button>
</div>
<table class="table table-bordered table-condensed table-striped" id="tableId">
    <thead class="bg-dark text-white">
        <tr>
            <th>Serial Number</th>
            <th>KAM Name</th>
            <th>Total Clients</th>
            <th>Active Clients</th>
        </tr>
    </thead>
    <tbody class="bg-white divide-y divide-gray-200">
        @php
            use App\Models\Pop;
            $sumOfTotalClients = 0;
            $sumOfActiveClients = 0;
            $total_resellers = 0;
        @endphp
        @foreach ($users as $user)
            @php
                $all_resellers_ids = $user->resellers()->count();
                $resellers_ids = $user->resellers()
                                            ->whereBetween('resellers.created_at', [$start, $end])
                                            ->pluck('resellers.id');

                $pops = Pop::whereIn('reseller_id', $resellers_ids)->pluck('id');

                $total_clients = $clients->whereIn('pop_id', $pops)->count();
                $active_clients = $clients->whereIn('pop_id', $pops)->where('clients_status', 'active')->count();


                $sumOfTotalClients += $total_clients;
                $sumOfActiveClients += $active_clients;
                $total_resellers += $all_resellers_ids;
            @endphp
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $user->name }} ({{$all_resellers_ids}}) </td>
                <td>{{ $total_clients }}</td>
                <td>{{ $active_clients }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="2"><b>Total ({{$total_resellers}})</b></td>
            <td><b>{{ $sumOfTotalClients }}</b></td>
            <td><b>{{ $sumOfActiveClients }}</b></td>
        </tr>
    </tbody>
</table>

<script>
    // Excel Export
    document.getElementById("downloadExcel").addEventListener("click", function () {
        let table = document.getElementById("tableId");
        let ws = XLSX.utils.table_to_sheet(table);

        // Auto-fit column width
        let wscols = [];
        for (let i = 0; i < table.rows[0].cells.length; i++) {
            wscols.push({ wch: table.rows[0].cells[i].innerText.length + 5 });
        }
        ws['!cols'] = wscols;

        let wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Report");
        XLSX.writeFile(wb, "Report.xlsx");
    });

    // PDF Export
    document.getElementById("downloadPDF").addEventListener("click", function () {
        let element = document.getElementById("result");
        let opt = {
            margin:       10,
            filename:     'Report.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 3 }, // Increase scale for better quality
            jsPDF:        { unit: 'mm', format: 'a4', orientation: 'landscape' }
        };
        html2pdf().set(opt).from(element).save();
    });
</script>

